/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.serialization.SerializationException;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.routing.AbstractAggregator;
import org.mule.runtime.core.routing.AggregationException;
import org.mule.runtime.core.routing.EventGroup;
import org.mule.runtime.core.routing.correlation.CollectionCorrelatorCallback;
import org.mule.runtime.core.routing.correlation.CorrelationSequenceComparator;
import org.mule.runtime.core.routing.correlation.EventCorrelatorCallback;

public class MessageChunkAggregator
extends AbstractAggregator {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Comparator eventComparator = new CorrelationSequenceComparator();

    @Override
    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new CollectionCorrelatorCallback(muleContext, this.storePrefix){

            @Override
            public Event aggregateEvents(EventGroup events) throws AggregationException {
                Event[] collectedEvents;
                try {
                    collectedEvents = events.toArray(false);
                }
                catch (ObjectStoreException e) {
                    throw new AggregationException(events, (Processor)MessageChunkAggregator.this, (Throwable)((Object)e));
                }
                Event firstEvent = collectedEvents[0];
                Arrays.sort(collectedEvents, MessageChunkAggregator.this.eventComparator);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                try {
                    for (Event event : collectedEvents) {
                        baos.write(event.getMessageAsBytes(this.muleContext));
                    }
                    InternalMessage.Builder builder = InternalMessage.builder(firstEvent.getMessage());
                    try {
                        builder.payload(this.muleContext.getObjectSerializer().getInternalProtocol().deserialize(baos.toByteArray()));
                    }
                    catch (SerializationException e) {
                        builder.payload(baos.toByteArray());
                    }
                    Event event = Event.builder(collectedEvents[collectedEvents.length - 1]).message(builder.build()).session(this.getMergedSession(events.toArray())).build();
                    return event;
                }
                catch (Exception e) {
                    throw new AggregationException(events, (Processor)MessageChunkAggregator.this, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                }
            }
        };
    }
}

