/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.el.ExpressionEvaluator;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.routing.AbstractSplitter;
import org.mule.runtime.core.routing.MapSplitter;
import org.w3c.dom.NodeList;

public class ExpressionSplitter
extends AbstractSplitter
implements Initialisable {
    protected ExpressionEvaluator expressionManager;
    protected ExpressionConfig config = new ExpressionConfig();

    public ExpressionSplitter() {
    }

    public ExpressionSplitter(ExpressionConfig config) {
        this.config = config;
    }

    public void initialise() throws InitialisationException {
        this.expressionManager = this.muleContext.getExpressionManager();
        this.config.validate(this.expressionManager);
    }

    @Override
    protected List<Event> splitMessage(Event event) {
        List<Object> result = this.muleContext.getExpressionManager().evaluate(this.config.getFullExpression(this.expressionManager), event, this.flowConstruct).getValue();
        if (result instanceof Object[]) {
            result = Arrays.asList((Object[])result);
        }
        if (result instanceof Iterable) {
            ArrayList<Event> messages = new ArrayList<Event>();
            ((Iterable)result).iterator().forEachRemaining(value -> messages.add(Event.builder(event).message(InternalMessage.builder().payload(value).build()).build()));
            return messages;
        }
        if (result instanceof Map) {
            LinkedList<Event> list = new LinkedList<Event>();
            Set set = ((Map)((Object)result)).entrySet();
            for (Map.Entry entry : set) {
                Event newEvent = Event.builder(event).message(InternalMessage.builder().payload(entry.getValue()).build()).addVariable(MapSplitter.MAP_ENTRY_KEY, entry.getKey()).build();
                list.add(newEvent);
            }
            return list;
        }
        if (result instanceof InternalMessage) {
            return Collections.singletonList(Event.builder(event).message((InternalMessage)((Object)result)).build());
        }
        if (result instanceof NodeList) {
            NodeList nodeList = (NodeList)((Object)result);
            ArrayList<Event> messages = new ArrayList<Event>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                messages.add(Event.builder(event).message(InternalMessage.builder().payload(nodeList.item(i)).build()).build());
            }
            return messages;
        }
        if (result == null) {
            return new ArrayList<Event>();
        }
        this.logger.info("The expression does not evaluate to a type that can be split: " + result.getClass().getName());
        return Collections.singletonList(Event.builder(event).message(InternalMessage.builder().payload(result).build()).build());
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }
}

