/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.IteratorUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.api.store.PartitionableObjectStore;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.store.DeserializationPostInitialisable;

public class EventGroup
implements Comparable<EventGroup>,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final Event[] EMPTY_EVENTS_ARRAY = new Event[0];
    public static final String MULE_ARRIVAL_ORDER_PROPERTY = "MULE_ARRIVAL_ORDER";
    private final Object groupId;
    private transient PartitionableObjectStore<Event> eventsObjectStore;
    private final String storePrefix;
    private final String eventsPartitionKey;
    private final long created = System.currentTimeMillis();
    private final Integer expectedSize;
    private transient MuleContext muleContext;
    private int arrivalOrderCounter = 0;
    public static final String DEFAULT_STORE_PREFIX = "DEFAULT_STORE";

    public EventGroup(Object groupId, MuleContext muleContext) {
        this(groupId, muleContext, Optional.empty(), DEFAULT_STORE_PREFIX);
    }

    public EventGroup(Object groupId, MuleContext muleContext, Optional<Integer> expectedSize, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
        this.eventsPartitionKey = storePrefix + ".eventGroups." + groupId;
        this.expectedSize = expectedSize.orElse(null);
        this.groupId = groupId;
    }

    @Override
    public int compareTo(EventGroup other) {
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator<Event> iterator() throws ObjectStoreException {
        return this.iterator(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Event> iterator(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray(sortByArrival));
        }
    }

    public Event[] toArray() throws ObjectStoreException {
        return this.toArray(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event[] toArray(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            List<Serializable> keys = this.eventsObjectStore.allKeys(this.eventsPartitionKey);
            Event[] eventArray = new Event[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                eventArray[i] = this.eventsObjectStore.retrieve(keys.get(i), this.eventsPartitionKey);
            }
            if (sortByArrival) {
                Arrays.sort(eventArray, new ArrivalOrderEventComparator());
            }
            return eventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            event = Event.builder(event).addVariable(MULE_ARRIVAL_ORDER_PROPERTY, ++this.arrivalOrderCounter).build();
            String key = this.getEventKey(event);
            this.eventsObjectStore.store((Serializable)((Object)key), event, this.eventsPartitionKey);
        }
    }

    private String getEventKey(Event event) {
        StringBuilder stringBuilder = new StringBuilder();
        event.getGroupCorrelation().getSequence().ifPresent(v -> stringBuilder.append(v + "-"));
        stringBuilder.append(event.hashCode());
        stringBuilder.append("-");
        stringBuilder.append(event.getContext().getId());
        return stringBuilder.toString();
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            try {
                return this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
            }
            catch (ObjectStoreException e) {
                return -1;
            }
        }
    }

    public Optional<Integer> expectedSize() {
        return Optional.ofNullable(this.expectedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.eventsObjectStore.clear(this.eventsPartitionKey);
            this.eventsObjectStore.close(this.eventsPartitionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize().map(v -> v.toString()).orElse("<not set>"));
        try {
            EventGroup eventGroup = this;
            synchronized (eventGroup) {
                int currentSize = this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
                buf.append(", current events=").append(currentSize);
                if (currentSize > 0) {
                    buf.append(" [");
                    Iterator<Serializable> i = this.eventsObjectStore.allKeys(this.eventsPartitionKey).iterator();
                    while (i.hasNext()) {
                        Serializable id = i.next();
                        buf.append(this.eventsObjectStore.retrieve(id, this.eventsPartitionKey).getCorrelationId());
                        if (!i.hasNext()) continue;
                        buf.append(", ");
                    }
                    buf.append(']');
                }
            }
        }
        catch (ObjectStoreException e) {
            buf.append("ObjectStoreException " + (Object)((Object)e) + " caught:" + e.getMessage());
        }
        buf.append('}');
        return buf.toString();
    }

    public Event getMessageCollectionEvent() {
        try {
            if (this.size() > 0) {
                Event[] muleEvents = this.toArray(true);
                Event lastEvent = muleEvents[muleEvents.length - 1];
                List messageList = Arrays.stream(muleEvents).map(event -> event.getMessage()).collect(Collectors.toList());
                Message.Builder builder = InternalMessage.builder().collectionPayload((Collection)messageList, (Class)InternalMessage.class);
                Event muleEvent = Event.builder(lastEvent).message(builder.build()).session(this.getMergedSession(muleEvents)).build();
                return muleEvent;
            }
            return null;
        }
        catch (ObjectStoreException e) {
            return null;
        }
    }

    protected MuleSession getMergedSession(Event[] events) throws ObjectStoreException {
        DefaultMuleSession session = new DefaultMuleSession(events[0].getSession());
        for (int i = 1; i < events.length - 1; ++i) {
            this.addAndOverrideSessionProperties(session, events[i]);
        }
        this.addAndOverrideSessionProperties(session, events[events.length - 1]);
        return session;
    }

    private void addAndOverrideSessionProperties(MuleSession session, Event event) {
        for (String name : event.getSession().getPropertyNamesAsSet()) {
            session.setProperty(name, event.getSession().getProperty(name));
        }
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
    }

    public void initEventsStore(PartitionableObjectStore<Event> events) throws ObjectStoreException {
        this.eventsObjectStore = events;
        events.open(this.eventsPartitionKey);
    }

    public boolean isInitialised() {
        return this.muleContext != null;
    }

    public final class ArrivalOrderEventComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event event1, Event event2) {
            return this.getEventOrder(event1) - this.getEventOrder(event2);
        }

        private int getEventOrder(Event event) {
            Integer orderVariable = (Integer)event.getVariable(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY).getValue();
            return orderVariable != null ? orderVariable : -1;
        }
    }
}

