/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.simple;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.processor.simple.SimpleMessageProcessor;
import org.mule.runtime.core.util.AttributeEvaluator;

public class SetPayloadMessageProcessor
extends SimpleMessageProcessor {
    private DataType dataType;
    private AttributeEvaluator valueEvaluator = new AttributeEvaluator(null);

    @Override
    public Event process(Event event) throws MuleException {
        InternalMessage.Builder builder = InternalMessage.builder(event.getMessage());
        Event.Builder eventBuilder = Event.builder(event);
        if (this.dataType == null) {
            TypedValue typedValue = this.resolveTypedValue(event, eventBuilder);
            builder.payload(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType());
        } else {
            Object value = this.resolveValue(event);
            DataTypeParamsBuilder dataTypeBuilder = DataType.builder((DataType)this.dataType).type(value == null ? Object.class : value.getClass());
            builder.payload(value).mediaType(dataTypeBuilder.build().getMediaType());
        }
        return eventBuilder.message(builder.build()).build();
    }

    private Object resolveValue(Event event) {
        Object value = this.valueEvaluator.getRawValue() == null ? null : this.valueEvaluator.resolveValue(event);
        return value;
    }

    private TypedValue resolveTypedValue(Event event, Event.Builder eventBuilder) {
        if (this.valueEvaluator.getRawValue() == null) {
            return new TypedValue(null, DataType.OBJECT);
        }
        return this.valueEvaluator.resolveTypedValue(event, eventBuilder);
    }

    public void setMimeType(String mimeType) {
        this.setDataType(DataType.builder((DataType)(this.dataType == null ? DataType.OBJECT : this.dataType)).mediaType(mimeType).build());
    }

    public void setEncoding(String encoding) {
        this.setDataType(DataType.builder((DataType)(this.dataType == null ? DataType.OBJECT : this.dataType)).charset(encoding).build());
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType.getMediaType().getCharset().isPresent() ? dataType : DataType.builder((DataType)dataType).build();
    }

    public void setValue(String value) {
        this.valueEvaluator = new AttributeEvaluator(value);
    }

    public void initialise() throws InitialisationException {
        this.valueEvaluator.initialize(this.muleContext.getExpressionManager());
    }
}

