/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.processor.chain.AbstractMessageProcessorChainBuilder;

public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder {
    @Override
    public MessageProcessorChain build() {
        LinkedList<Processor> tempList = new LinkedList<Processor>();
        LinkedList<Processor> processorsForLifecycle = new LinkedList<Processor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            Processor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (processor instanceof InterceptingMessageProcessor) {
                InterceptingMessageProcessor interceptingProcessor = (InterceptingMessageProcessor)processor;
                if (i + 1 < this.processors.size()) {
                    MessageProcessorChain innerChain = this.createSimpleChain(tempList);
                    processorsForLifecycle.addFirst(innerChain);
                    interceptingProcessor.setListener(innerChain);
                }
                tempList = new LinkedList<Processor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(processor);
        }
        Processor head = tempList.size() == 1 ? (Processor)tempList.get(0) : this.createSimpleChain(tempList);
        processorsForLifecycle.addFirst(head);
        return this.createInterceptingChain(head, this.processors, processorsForLifecycle);
    }

    protected MessageProcessorChain createSimpleChain(List<Processor> tempList) {
        if (tempList.size() == 1 && tempList.get(0) instanceof SimpleMessageProcessorChain) {
            return (MessageProcessorChain)tempList.get(0);
        }
        return new SimpleMessageProcessorChain("(inner chain) of " + this.name, new ArrayList<Processor>(tempList));
    }

    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
        return new DefaultMessageProcessorChain("(outer intercepting chain) of " + this.name, head, processors, processorsForLifecycle);
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(Processor ... processors) {
        for (Processor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<Processor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(Processor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    static class DefaultMessageProcessorChain
    extends AbstractMessageProcessorChain {
        private Processor head;
        private List<Processor> processorsForLifecycle;

        DefaultMessageProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, processors);
            this.head = head;
            this.processorsForLifecycle = processorsForLifecycle;
        }

        @Override
        protected List<Processor> getMessageProcessorsForLifecycle() {
            return this.processorsForLifecycle;
        }

        @Override
        protected List<Processor> getProcessorsToExecute() {
            return Collections.singletonList(this.head);
        }
    }

    static class SimpleMessageProcessorChain
    extends AbstractMessageProcessorChain {
        SimpleMessageProcessorChain(String name, List<Processor> processors) {
            super(name, processors);
        }

        @Override
        protected List<Processor> getProcessorsToExecute() {
            return this.processors;
        }
    }
}

