/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.transaction.MuleTransactionConfig;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Lifecycle {
    protected MessagingExceptionHandler exceptionListener;
    protected MuleTransactionConfig transactionConfig;

    @Override
    public Event process(Event event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate(this.muleContext, this.flowConstruct, this.transactionConfig, this.exceptionListener);
        ExecutionCallback<Event> processingCallback = () -> this.processNext(event);
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), (Throwable)e);
        }
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void initialise() throws InitialisationException {
        if (this.exceptionListener == null) {
            this.exceptionListener = this.muleContext.getDefaultErrorHandler();
        }
        if (this.exceptionListener instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.exceptionListener)).setFlowConstruct(this.flowConstruct);
        }
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)this.exceptionListener).initialise();
        }
    }

    public void dispose() {
        if (this.exceptionListener instanceof Disposable) {
            ((Disposable)this.exceptionListener).dispose();
        }
    }

    public void start() throws MuleException {
        if (this.exceptionListener instanceof Startable) {
            ((Startable)this.exceptionListener).start();
        }
    }

    public void stop() throws MuleException {
        if (this.exceptionListener instanceof Stoppable) {
            ((Stoppable)this.exceptionListener).stop();
        }
    }
}

