/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class SecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Initialisable {
    private SecurityFilter filter;

    @Deprecated
    public SecurityFilterMessageProcessor() {
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.filter, this.muleContext);
    }

    public SecurityFilterMessageProcessor(SecurityFilter filter) {
        this.filter = filter;
    }

    public SecurityFilter getFilter() {
        return this.filter;
    }

    @Override
    public Event process(Event event) throws MuleException {
        if (this.filter != null) {
            event = this.filter.doFilter(event);
        }
        return this.processNext(event);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.filter == null) {
            return Flux.from(publisher).transform(this.applyNext());
        }
        return Flux.from(publisher).doOnNext(event -> {
            try {
                this.filter.doFilter((Event)event);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).transform(this.applyNext());
    }

    public void setFilter(SecurityFilter filter) {
        this.filter = filter;
    }
}

