/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.List;
import java.util.ServiceLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TypedTransactionFactory;
import org.mule.runtime.core.processor.DelegateTransactionFactory;
import org.mule.runtime.core.processor.TransactionalInterceptingMessageProcessor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionType;

public class BlockMessageProcessor
extends TransactionalInterceptingMessageProcessor
implements Lifecycle,
MuleContextAware {
    protected List messageProcessors;
    protected String transactionalAction;
    private TransactionType transactionType;
    private MessageProcessorChain delegate;

    @Override
    public Event process(Event event) throws MuleException {
        return this.delegate.process(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'transaction' child processor chain");
        TransactionalInterceptingMessageProcessor txProcessor = new TransactionalInterceptingMessageProcessor();
        txProcessor.setExceptionListener(this.exceptionListener);
        txProcessor.setTransactionConfig(this.createTransactionConfig(this.transactionalAction, this.transactionType));
        this.transactionConfig.setFactory(this.getTransactionFactory());
        builder.chain(txProcessor);
        for (Object processor : this.messageProcessors) {
            if (processor instanceof Processor) {
                builder.chain((Processor)processor);
            } else if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)processor);
            } else {
                throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
            }
            if (!(processor instanceof MessagingExceptionHandlerAware)) continue;
            ((MessagingExceptionHandlerAware)processor).setMessagingExceptionHandler(this.exceptionListener);
        }
        this.delegate = builder.build();
    }

    protected TransactionFactory getTransactionFactory() {
        return new DelegateTransactionFactory();
    }

    protected MuleTransactionConfig createTransactionConfig(String action, TransactionType type) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setActionAsString(action);
        transactionConfig.setFactory(this.lookUpTransactionFactory(type));
        return transactionConfig;
    }

    private TransactionFactory lookUpTransactionFactory(TransactionType type) {
        for (TypedTransactionFactory possibleFactory : ServiceLoader.load(TypedTransactionFactory.class)) {
            if (!type.equals((Object)possibleFactory.getType())) continue;
            try {
                return (TransactionFactory)possibleFactory.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to generate a factory for transaction %s.", new Object[]{type})));
            }
        }
        throw new IllegalArgumentException(String.format("No factory available for transaction type %s", new Object[]{type}));
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setTransactionalAction(String action) {
        this.transactionalAction = action;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }
}

