/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.routing.MessageProcessorFilterPair;

public abstract class AbstractRedeliveryPolicy
extends AbstractInterceptingMessageProcessor
implements Processor,
Lifecycle,
MuleContextAware,
FlowConstructAware,
MessagingExceptionHandlerAware {
    protected FlowConstruct flowConstruct;
    protected int maxRedeliveryCount;
    protected Processor deadLetterQueue;
    public static final int REDELIVERY_FAIL_ON_FIRST = 0;
    private MessagingExceptionHandler messagingExceptionHandler;

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (this.deadLetterQueue instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.deadLetterQueue)).setFlowConstruct(flowConstruct);
        }
    }

    public void initialise() throws InitialisationException {
        if (this.maxRedeliveryCount < 0) {
            throw new InitialisationException(CoreMessages.initialisationFailure("maxRedeliveryCount must be positive"), (Initialisable)this);
        }
        if (this.deadLetterQueue instanceof Initialisable) {
            ((Initialisable)this.deadLetterQueue).initialise();
        }
    }

    public void start() throws MuleException {
        if (this.deadLetterQueue instanceof Startable) {
            ((Startable)this.deadLetterQueue).start();
        }
    }

    public void stop() throws MuleException {
        if (this.deadLetterQueue instanceof Stoppable) {
            ((Stoppable)this.deadLetterQueue).stop();
        }
    }

    public void dispose() {
        if (this.deadLetterQueue instanceof Disposable) {
            ((Disposable)this.deadLetterQueue).dispose();
        }
    }

    public int getMaxRedeliveryCount() {
        return this.maxRedeliveryCount;
    }

    public void setMaxRedeliveryCount(int maxRedeliveryCount) {
        this.maxRedeliveryCount = maxRedeliveryCount;
    }

    public Processor getTheFailedMessageProcessor() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(MessageProcessorFilterPair failedMessageProcessorPair) {
        this.deadLetterQueue = failedMessageProcessorPair.getMessageProcessor();
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
        if (this.deadLetterQueue instanceof MessagingExceptionHandlerAware) {
            ((MessagingExceptionHandlerAware)((Object)this.deadLetterQueue)).setMessagingExceptionHandler(messagingExceptionHandler);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        if (this.deadLetterQueue instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.deadLetterQueue)).setMuleContext(context);
        }
    }
}

