/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;

public abstract class AbstractMuleObjectOwner<T>
implements Lifecycle,
MuleContextAware,
FlowConstructAware,
MessagingExceptionHandlerAware {
    @Inject
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected MessagingExceptionHandler messagingExceptionHandler;

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        LifecycleUtils.setMuleContextIfNeeded(this.getOwnedObjects(), muleContext);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        LifecycleUtils.setFlowConstructIfNeeded(this.getOwnedObjects(), flowConstruct);
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = messagingExceptionHandler;
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void initialise() throws InitialisationException {
        this.setMuleContext(this.muleContext);
        this.setFlowConstruct(this.flowConstruct);
        for (T object : this.getOwnedObjects()) {
            if (this.messagingExceptionHandler == null || !(object instanceof MessagingExceptionHandlerAware)) continue;
            ((MessagingExceptionHandlerAware)object).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        LifecycleUtils.initialiseIfNeeded(this.getOwnedObjects());
    }

    public void dispose() {
        for (T processor : this.getOwnedObjects()) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)processor).dispose();
        }
    }

    public void start() throws MuleException {
        for (T processor : this.getOwnedObjects()) {
            if (!(processor instanceof Startable)) continue;
            ((Startable)processor).start();
        }
    }

    public void stop() throws MuleException {
        for (T processor : this.getOwnedObjects()) {
            if (!(processor instanceof Stoppable)) continue;
            ((Stoppable)processor).stop();
        }
    }

    protected MessagingExceptionHandler getMessagingExceptionHandler() {
        return this.messagingExceptionHandler;
    }

    protected abstract List<T> getOwnedObjects();
}

