/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.Policy;

public abstract class AbstractCompositePolicy<ParametersTransformer, ParametersProcessor> {
    private final List<Policy> parameterizedPolicies;
    private final Optional<ParametersTransformer> parametersTransformer;
    private final ParametersProcessor parametersProcessor;

    public AbstractCompositePolicy(List<Policy> policies, Optional<ParametersTransformer> parametersTransformer, ParametersProcessor parametersProcessor) {
        Preconditions.checkArgument((!policies.isEmpty() ? 1 : 0) != 0, (String)"policies list cannot be empty");
        this.parameterizedPolicies = policies;
        this.parametersTransformer = parametersTransformer;
        this.parametersProcessor = parametersProcessor;
    }

    public final Event processPolicies(Event operationEvent) throws Exception {
        return new NextOperationCall(operationEvent).process(operationEvent);
    }

    protected Optional<ParametersTransformer> getParametersTransformer() {
        return this.parametersTransformer;
    }

    protected ParametersProcessor getParametersProcessor() {
        return this.parametersProcessor;
    }

    protected abstract Event processNextOperation(Event var1) throws MuleException;

    protected abstract Event processPolicy(Policy var1, Processor var2, Event var3) throws Exception;

    public class NextOperationCall
    extends AbstractAnnotatedObject
    implements Processor {
        private final Event originalEvent;
        private int index = 0;

        public NextOperationCall(Event originalEvent) {
            this.originalEvent = originalEvent;
        }

        @Override
        public Event process(Event event) throws MuleException {
            Preconditions.checkState((this.index <= AbstractCompositePolicy.this.parameterizedPolicies.size() ? 1 : 0) != 0, (String)"composite policy index is greater that the number of policies.");
            if (this.index == AbstractCompositePolicy.this.parameterizedPolicies.size()) {
                return AbstractCompositePolicy.this.processNextOperation(event);
            }
            Policy policy = (Policy)AbstractCompositePolicy.this.parameterizedPolicies.get(this.index);
            ++this.index;
            try {
                return AbstractCompositePolicy.this.processPolicy(policy, this, this.originalEvent);
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        }
    }
}

