/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.lifecycle;

import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.core.api.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.api.lifecycle.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDisposeLifecycleInterceptor
implements LifecycleInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitDisposeLifecycleInterceptor.class);
    private Set<Integer> initialisedObjects = new HashSet<Integer>();
    private boolean initialiseCompleted = false;

    @Override
    public boolean beforeLifecycle(LifecyclePhase phase, Object object) {
        if (this.initialiseCompleted) {
            return true;
        }
        if (this.isDispose(phase) && object instanceof Initialisable && !this.initialisedObjects.contains(this.getLifecycleTrackingKey(object))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skipping %s lifecycle phase on object because %s phase failed before it could be applied on it. Object is: %s", "dispose", "initialise", object));
            }
            return false;
        }
        return true;
    }

    @Override
    public void afterLifecycle(LifecyclePhase phase, Object object) {
        if (this.isInitialise(phase) && !this.initialiseCompleted) {
            this.initialisedObjects.add(this.getLifecycleTrackingKey(object));
        }
    }

    @Override
    public void onPhaseCompleted(LifecyclePhase phase) {
        if (this.isInitialise(phase)) {
            this.initialiseCompleted = true;
            this.initialisedObjects = null;
        }
    }

    private int getLifecycleTrackingKey(Object object) {
        return System.identityHashCode(object);
    }

    private boolean isInitialise(LifecyclePhase phase) {
        return "initialise".equals(phase.getName());
    }

    private boolean isDispose(LifecyclePhase phase) {
        return "dispose".equals(phase.getName());
    }
}

