/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.text.NumberFormat;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class NumberToString
extends AbstractTransformer
implements DiscoverableTransformer {
    private NumberFormat numberFormat;
    private int priorityWeighting = 2;

    public NumberToString() {
        this.registerSourceType(DataType.NUMBER);
        this.setReturnDataType(DataType.STRING);
    }

    public NumberToString(NumberFormat numberFormat) {
        this();
        this.numberFormat = numberFormat;
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            return "";
        }
        if (this.numberFormat != null) {
            return this.numberFormat.format(src);
        }
        return ((Number)src).toString();
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

