/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.mule.runtime.core.internal.streaming.object.AbstractConsumer;
import org.mule.runtime.core.internal.streaming.object.Producer;

public class ListConsumer<T>
extends AbstractConsumer<T, List<T>> {
    private List<T> currentPage = null;
    private int index;
    private int pageSize;

    public ListConsumer(Producer<List<T>> producer) {
        super(producer);
        this.reset();
    }

    @Override
    protected T doConsume() throws NoSuchElementException {
        if (this.isConsumed()) {
            throw new NoSuchElementException();
        }
        T element = this.currentPage.get(this.index);
        ++this.index;
        return element;
    }

    @Override
    protected boolean checkConsumed() {
        if (this.index >= this.pageSize) {
            this.loadNextPage(this.producer);
            return this.pageSize == 0;
        }
        return false;
    }

    @Override
    public int size() {
        return this.producer.size();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentPage = null;
    }

    private void reset() {
        this.index = 0;
        this.pageSize = this.currentPage == null ? 0 : this.currentPage.size();
    }

    private void loadNextPage(Producer<List<T>> producer) {
        this.currentPage = producer.produce();
        this.reset();
    }
}

