/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes.factory;

import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.streaming.CursorStream;
import org.mule.runtime.api.streaming.CursorStreamProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingManagerAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamAdapter;
import org.mule.runtime.core.internal.streaming.bytes.CursorStreamProviderAdapter;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;

abstract class AbstractCursorStreamProviderFactory
implements CursorStreamProviderFactory {
    private final ByteStreamingManagerAdapter streamingManager;
    private final ByteBufferManager bufferManager;

    AbstractCursorStreamProviderFactory(ByteStreamingManagerAdapter streamingManager, ByteBufferManager bufferManager) {
        this.streamingManager = streamingManager;
        this.bufferManager = bufferManager;
    }

    @Override
    public final Either<CursorStreamProvider, InputStream> of(Event event, InputStream inputStream) {
        if (inputStream instanceof CursorStreamAdapter) {
            return Either.left(((CursorStreamAdapter)((Object)inputStream)).getProvider());
        }
        Either<CursorStreamProviderAdapter, InputStream> value = this.resolve(inputStream, event);
        return value.mapLeft(provider -> {
            this.streamingManager.onOpen((CursorStreamProviderAdapter)provider);
            return new ManagedCursorStreamProvider((CursorStreamProviderAdapter)provider);
        });
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract Either<CursorStreamProviderAdapter, InputStream> resolve(InputStream var1, Event var2);

    private class ManagedCursorStreamDecorator
    extends CursorStream {
        private final CursorStreamAdapter delegate;

        private ManagedCursorStreamDecorator(CursorStreamAdapter delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                AbstractCursorStreamProviderFactory.this.streamingManager.onClose(this.delegate);
            }
        }

        public long getPosition() {
            return this.delegate.getPosition();
        }

        public void seek(long position) throws IOException {
            this.delegate.seek(position);
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    private class ManagedCursorStreamProvider
    implements CursorStreamProvider {
        private final CursorStreamProviderAdapter delegate;

        public ManagedCursorStreamProvider(CursorStreamProviderAdapter delegate) {
            this.delegate = delegate;
        }

        public CursorStream openCursor() {
            CursorStreamAdapter cursor = (CursorStreamAdapter)this.delegate.openCursor();
            AbstractCursorStreamProviderFactory.this.streamingManager.onOpen(cursor);
            return new ManagedCursorStreamDecorator(cursor);
        }

        public void close() {
            this.delegate.close();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }
    }
}

