/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.InputStream;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.api.streaming.CursorStream;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.streaming.bytes.AbstractCursorStreamProviderAdapter;
import org.mule.runtime.core.internal.streaming.bytes.BufferedCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.SwitchingInputStreamBuffer;
import org.mule.runtime.core.streaming.bytes.FileStoreCursorStreamConfig;

public class FileStoreCursorStreamProvider
extends AbstractCursorStreamProviderAdapter {
    private final int bufferSize;
    private final SwitchingInputStreamBuffer buffer;

    public FileStoreCursorStreamProvider(InputStream wrappedStream, FileStoreCursorStreamConfig config, Event event, ByteBufferManager bufferManager, ScheduledExecutorService executorService) {
        super(wrappedStream, bufferManager, event);
        this.bufferSize = config.getMaxInMemorySize().toBytes();
        this.buffer = SwitchingInputStreamBuffer.of(wrappedStream, config, bufferManager, executorService);
    }

    @Override
    protected CursorStream doOpenCursor() {
        return new BufferedCursorStream(this.buffer, this.getBufferManager(), this.bufferSize, this);
    }

    @Override
    public void releaseResources() {
        this.buffer.close();
    }
}

