/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ComponentId;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationInstanceNotification;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.context.notification.NotificationException;
import org.mule.runtime.core.internal.metadata.DefaultMetadataCache;
import org.mule.runtime.core.internal.metadata.InvalidComponentIdException;

public class MuleMetadataService
implements MetadataService,
Initialisable {
    private static final String PROCESSOR_NOT_FOUND = "Processor doesn't exist in the given index [%s]";
    private static final String FLOW_NOT_FOUND = "Flow [%s] doesn't exist";
    private static final String SOURCE_NOT_FOUND = "Flow doesn't contain a message source";
    private static final String COMPONENT_NOT_METADATA_PROVIDER = "Component [%s] is not a MetadataProvider or MetadataEntityProvider, no information available";
    private static final String COMPONENT_NOT_METADATA_KEY_PROVIDER = "Component [%s] is not a MetadataKeyProvider, no information available";
    private static final String EXCEPTION_RESOLVING_COMPONENT_METADATA = "An exception occurred while resolving metadata for component '%s'";
    private static final String EXCEPTION_RESOLVING_METADATA_KEYS = "An exception occurred while resolving Component MetadataKeys";
    private static final String CONFIG_NOT_FOUND = "Configuration named [%s] doesn't exist";
    @Inject
    private MuleContext muleContext;
    private final LoadingCache<String, MetadataCache> caches = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, MetadataCache>(){

        public MetadataCache load(String id) throws Exception {
            return new DefaultMetadataCache();
        }
    });

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.registerListener(notification -> {
                try {
                    if (notification.getAction() == ConfigurationInstanceNotification.CONFIGURATION_STOPPED) {
                        String name = ((ConfigurationInstanceNotification)notification).getConfigurationInstance().getName();
                        this.disposeCache(name);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while looking for the MetadataManager in the registry", e);
                }
            });
        }
        catch (NotificationException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not register ConfigurationInstanceListener"), (Throwable)((Object)e), (Initialisable)this);
        }
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentId componentId) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataKeyProvider(componentId).getMetadataKeys(), EXCEPTION_RESOLVING_METADATA_KEYS);
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(ComponentId componentId, MetadataKey key) {
        return this.getComponentMetadataWithKey(componentId, key, this::lookupProcessor);
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(ComponentId componentId) {
        return this.getComponentMetadata(componentId, this::lookupProcessor);
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(ComponentId componentId, MetadataKey key) {
        return this.getComponentMetadataWithKey(componentId, key, this::lookupSource);
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(ComponentId componentId) {
        return this.getComponentMetadata(componentId, this::lookupSource);
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(ComponentId componentId, MetadataKey key) {
        return this.exceptionHandledMetadataFetch(() -> this.findEntityMetadataProvider(componentId).getEntityMetadata(key), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, componentId));
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(ComponentId componentId) {
        return this.exceptionHandledMetadataFetch(() -> this.findEntityMetadataProvider(componentId).getEntityKeys(), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, componentId));
    }

    public void disposeCache(String id) {
        this.caches.invalidate((Object)id);
    }

    public MetadataCache getMetadataCache(String id) {
        try {
            return (MetadataCache)this.caches.get((Object)id);
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not get the cache with id:" + id)), (Throwable)e);
        }
    }

    public Map<String, ? extends MetadataCache> getMetadataCaches() {
        return ImmutableMap.copyOf((Map)this.caches.asMap());
    }

    private <T> MetadataResult<T> exceptionHandledMetadataFetch(MetadataDelegate<T> producer, String failureMessage) {
        try {
            return producer.get();
        }
        catch (InvalidComponentIdException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(e.getFailureCode()).onComponent()});
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    private MetadataKeyProvider findMetadataKeyProvider(ComponentId componentId) throws InvalidComponentIdException {
        try {
            return componentId.getFlowName().isPresent() ? (MetadataKeyProvider)this.lookupComponent(componentId) : this.lookupConfig(componentId.getComponentPath());
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(COMPONENT_NOT_METADATA_KEY_PROVIDER, componentId)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private <T extends ComponentModel<T>> MetadataProvider<T> findMetadataProvider(ComponentId componentId, LookupComponent lookupComponent) throws InvalidComponentIdException {
        Flow flow = this.getFlow(componentId);
        try {
            return (MetadataProvider)lookupComponent.get(flow, componentId);
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(COMPONENT_NOT_METADATA_PROVIDER, componentId)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private Flow getFlow(ComponentId componentId) throws InvalidComponentIdException {
        Flow flow = (Flow)this.muleContext.getRegistry().lookupFlowConstruct((String)componentId.getFlowName().get());
        if (flow == null) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(FLOW_NOT_FOUND, componentId.getFlowName().get())), FailureCode.COMPONENT_NOT_FOUND);
        }
        return flow;
    }

    private EntityMetadataProvider findEntityMetadataProvider(ComponentId componentId) throws InvalidComponentIdException {
        try {
            return (EntityMetadataProvider)this.lookupComponent(componentId);
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(COMPONENT_NOT_METADATA_PROVIDER, componentId)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private Processor lookupProcessor(Flow flow, ComponentId componentId) throws InvalidComponentIdException {
        try {
            return (Processor)flow.getMessageProcessors().get(Integer.parseInt(componentId.getComponentPath()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(PROCESSOR_NOT_FOUND, componentId.getComponentPath())), e, FailureCode.COMPONENT_NOT_FOUND);
        }
    }

    private MessageSource lookupSource(Flow flow, ComponentId componentId) throws InvalidComponentIdException {
        MessageSource messageSource = flow.getMessageSource();
        if (messageSource == null) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)SOURCE_NOT_FOUND), FailureCode.COMPONENT_NOT_FOUND);
        }
        return messageSource;
    }

    private MetadataKeyProvider lookupConfig(String configName) throws InvalidComponentIdException {
        MetadataKeyProvider configurationProvider = (MetadataKeyProvider)this.muleContext.getRegistry().lookupObject(configName);
        if (configurationProvider != null) {
            return configurationProvider;
        }
        throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage((String)String.format(CONFIG_NOT_FOUND, configName)), FailureCode.COMPONENT_NOT_FOUND);
    }

    private Object lookupComponent(ComponentId componentId) throws InvalidComponentIdException {
        Flow flow = this.getFlow(componentId);
        return !componentId.getComponentPath().equals("-1") ? this.lookupProcessor(flow, componentId) : this.lookupSource(flow, componentId);
    }

    private <T extends ComponentModel<T>> MetadataResult<ComponentMetadataDescriptor<T>> getComponentMetadata(ComponentId componentId, LookupComponent lookupComponent) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataProvider(componentId, lookupComponent).getMetadata(), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, componentId));
    }

    private <T extends ComponentModel<T>> MetadataResult<ComponentMetadataDescriptor<T>> getComponentMetadataWithKey(ComponentId componentId, MetadataKey key, LookupComponent lookupComponent) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataProvider(componentId, lookupComponent).getMetadata(key), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, componentId));
    }

    @FunctionalInterface
    private static interface LookupComponent {
        public Object get(Flow var1, ComponentId var2) throws InvalidComponentIdException;
    }

    @FunctionalInterface
    private static interface MetadataDelegate<T> {
        public MetadataResult<T> get() throws MetadataResolvingException, InvalidComponentIdException;
    }
}

