/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lock.LockFactory;
import org.mule.runtime.core.api.lock.LockProvider;
import org.mule.runtime.core.internal.lock.InstanceLockGroup;
import org.mule.runtime.core.internal.lock.LockAdapter;
import org.mule.runtime.core.internal.lock.LockGroup;

public class MuleLockFactory
implements LockFactory,
MuleContextAware,
Initialisable,
Disposable {
    private LockGroup lockGroup;
    private LockProvider lockProvider;
    private MuleContext muleContext;

    @Override
    public synchronized Lock createLock(String lockId) {
        return new LockAdapter(lockId, this.lockGroup);
    }

    public void dispose() {
        this.lockGroup.dispose();
    }

    public void initialise() throws InitialisationException {
        if (this.lockProvider == null) {
            this.lockProvider = (LockProvider)this.muleContext.getRegistry().get("_muleLockProvider");
        }
        this.lockGroup = new InstanceLockGroup(this.lockProvider);
    }

    public void setLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

