/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.locator;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.ObjectNotFoundException;
import org.mule.runtime.core.api.locator.ConfigurationComponentLocator;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.util.ArrayUtils;

public class DefaultConfigurationComponentLocator
implements ConfigurationComponentLocator {
    private final MuleContext muleContext;

    @Inject
    public DefaultConfigurationComponentLocator(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Object findByName(String name) throws ObjectNotFoundException {
        Object object = this.muleContext.getRegistry().lookupObject(name);
        this.validateObjectIsPresent(name, object);
        return object;
    }

    private void validateObjectIsPresent(String name, Object object) {
        if (object == null) {
            throw new ObjectNotFoundException(name);
        }
    }

    @Override
    public Object findByPath(String componentPath) {
        Object[] parts = componentPath.split("/");
        if (parts.length == 0) {
            throw new IllegalArgumentException("Incomplete component path " + componentPath);
        }
        String type = parts[0];
        if (!"flow".equals(type)) {
            throw new IllegalArgumentException("Unsupported component type " + type);
        }
        if (parts.length == 1) {
            throw new IllegalArgumentException("Missing component path type element name in " + componentPath);
        }
        String typeElementName = parts[1];
        Flow flow = (Flow)this.muleContext.getRegistry().lookupFlowConstruct(typeElementName);
        this.validateObjectIsPresent(typeElementName, flow);
        if (parts.length == 2) {
            return flow;
        }
        String flowPartType = parts[2];
        if ("source".equals(flowPartType)) {
            return flow.getMessageSource();
        }
        if ("processors".equals(flowPartType)) {
            return this.resolveMessageProcessor(flow.getMessageProcessors(), ArrayUtils.subarray((Object[])parts, (int)4, (int)(parts.length - 1)));
        }
        if ("errorHandler".equals(flowPartType)) {
            throw new IllegalArgumentException("Cannot resolve processors inside error-handler yet");
        }
        throw new IllegalArgumentException(String.format("Flow part %s is invalid", flowPartType));
    }

    private Object resolveMessageProcessor(List<Processor> messageProcessors, Object[] processorIndexes) {
        if (processorIndexes.length > 1) {
            throw new IllegalArgumentException("Only one level of processor indexes is supported");
        }
        return messageProcessors.get(Integer.valueOf((String)processorIndexes[0]));
    }
}

