/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.client.AbstractPriorizableConnectorMessageProcessorProvider;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.connector.ConnectorOperationLocator;
import org.mule.runtime.core.api.connector.ConnectorOperationProvider;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;

public class MuleConnectorOperationLocator
implements ConnectorOperationLocator,
MuleContextAware,
Initialisable {
    private MuleContext muleContext;
    private Collection<ConnectorOperationProvider> connectorOperationProviders;

    public void initialise() throws InitialisationException {
        ArrayList<ConnectorOperationProvider> providers = new ArrayList<ConnectorOperationProvider>(this.muleContext.getRegistry().lookupObjects(ConnectorOperationProvider.class));
        Collections.sort(providers, (p1, p2) -> this.priority((ConnectorOperationProvider)p2) - this.priority((ConnectorOperationProvider)p1));
        this.connectorOperationProviders = providers;
    }

    private int priority(ConnectorOperationProvider provider) {
        if (provider instanceof AbstractPriorizableConnectorMessageProcessorProvider) {
            return ((AbstractPriorizableConnectorMessageProcessorProvider)provider).priority();
        }
        return 0;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Processor locateConnectorOperation(String url, OperationOptions operationOptions, MessageExchangePattern exchangePattern) throws MuleException {
        for (ConnectorOperationProvider connectorOperationProvider : this.connectorOperationProviders) {
            if (!connectorOperationProvider.supportsUrl(url)) continue;
            return connectorOperationProvider.getMessageProcessor(url, operationOptions, exchangePattern);
        }
        return null;
    }
}

