/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.expression.transformers;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.expression.transformers.AbstractExpressionTransformer;
import org.mule.runtime.core.expression.transformers.ExpressionArgument;
import org.mule.runtime.core.object.PrototypeObjectFactory;
import org.mule.runtime.core.util.BeanUtils;

public class BeanBuilderTransformer
extends AbstractExpressionTransformer {
    private ObjectFactory beanFactory;
    private Class<?> beanClass;

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public ObjectFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(ObjectFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getBeanFactory() == null && this.getBeanClass() == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("beanFactory"), (Initialisable)this);
        }
        if (this.getBeanClass() != null) {
            this.setBeanFactory(new PrototypeObjectFactory(this.getBeanClass()));
        }
        this.setReturnDataType(DataType.fromType(this.getBeanFactory().getObjectClass()));
        if (this.getBeanFactory() instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.getBeanFactory())).setMuleContext(this.muleContext);
        }
    }

    @Override
    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        Object bean;
        try {
            bean = this.getBeanFactory().getInstance(this.muleContext);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        HashMap<String, Object> args = new HashMap<String, Object>(this.arguments.size());
        for (ExpressionArgument argument : this.arguments) {
            Object value = null;
            try {
                value = argument.evaluate(event);
            }
            catch (ExpressionRuntimeException e) {
                throw new TransformerException(this, (Throwable)((Object)e));
            }
            if (!argument.isOptional() && value == null) {
                throw new TransformerException(CoreMessages.expressionReturnedNull(argument.getExpressionConfig().getExpression()), this);
            }
            args.put(argument.getName(), value);
        }
        try {
            BeanUtils.populate(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new TransformerException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TransformerException(this, e.getTargetException());
        }
        return bean;
    }
}

