/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;

public class RedeliveryExceeded
implements FlowConstructAware,
Initialisable {
    private List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    private MessageProcessorChain configuredMessageProcessors;
    private FlowConstruct flowConstruct;

    public void initialise() throws InitialisationException {
        this.configuredMessageProcessors = MessageProcessors.newChain(this.messageProcessors);
    }

    public List<Processor> getMessageProcessors() {
        return Collections.unmodifiableList(this.messageProcessors);
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public Event process(Event event) throws MuleException {
        Event result = event;
        if (!this.messageProcessors.isEmpty()) {
            result = this.configuredMessageProcessors.process(event);
        }
        if (result != null) {
            result = Event.builder(result).error(null).message(InternalMessage.builder(result.getMessage()).exceptionPayload(null).build()).build();
        }
        return result;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

