/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.message.ErrorTypeBuilder;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class ErrorTypeRepository {
    protected static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build();
    protected static final ErrorType UNKNOWN_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("UNKNOWN").parentErrorType(ANY_ERROR_TYPE).build();
    protected static final ErrorType CRITICAL_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("CRITICAL").parentErrorType(null).build();
    private Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private Map<ComponentIdentifier, ErrorType> internalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    public ErrorTypeRepository() {
        this.errorTypes.put(Errors.ComponentIdentifiers.ANY, ANY_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.CRITICAL, CRITICAL_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.UNKNOWN, UNKNOWN_ERROR_TYPE);
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.addErrorTypeTo(errorTypeIdentifier, parentErrorType, this.errorTypes);
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.addErrorTypeTo(errorTypeIdentifier, parentErrorType, this.internalErrorTypes);
    }

    private ErrorType addErrorTypeTo(ComponentIdentifier identifier, ErrorType parent, Map<ComponentIdentifier, ErrorType> map) {
        ErrorTypeBuilder errorTypeBuilder = ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent);
        ErrorType errorType = errorTypeBuilder.build();
        if (map.put(identifier, errorType) != null) {
            throw new IllegalStateException(String.format("An error type with identifier %s already exists", identifier));
        }
        return errorType;
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.lookupErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = Optional.ofNullable(this.internalErrorTypes.get(errorTypeIdentifier));
        }
        return errorType;
    }

    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }

    public ErrorType getCriticalErrorType() {
        return CRITICAL_ERROR_TYPE;
    }
}

