/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.el.context.AbstractMapContext;

class InboundPropertiesMapContext
extends AbstractMapContext<Serializable> {
    private Event event;

    public InboundPropertiesMapContext(Event event) {
        this.event = event;
    }

    @Override
    public Serializable doGet(String key) {
        return this.event.getMessage().getInboundProperty(key);
    }

    @Override
    public void doPut(String key, Serializable value) {
        throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable(key).getMessage());
    }

    @Override
    public void doRemove(String key) {
        throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable(key).getMessage());
    }

    @Override
    public Set<String> keySet() {
        return this.event.getMessage().getInboundPropertyNames();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(CoreMessages.inboundMessagePropertiesImmutable().getMessage());
    }

    public String toString() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String key : this.event.getMessage().getInboundPropertyNames()) {
            Serializable value = this.event.getMessage().getInboundProperty(key);
            map.put(key, value);
        }
        return ((Object)map).toString();
    }
}

