/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguage;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.el.DataWeaveExpressionLanguage;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;

public class ExtendedExpressionLanguageAdapter
implements ExtendedExpressionLanguage {
    private DataWeaveExpressionLanguage dataWeaveExpressionLanguage;
    private MVELExpressionLanguage mvelExpressionLanguage;
    private boolean forceMel = false;

    public ExtendedExpressionLanguageAdapter(DataWeaveExpressionLanguage dataWeaveExpressionLanguage, MVELExpressionLanguage mvelExpressionLanguage) {
        this.dataWeaveExpressionLanguage = dataWeaveExpressionLanguage;
        this.mvelExpressionLanguage = mvelExpressionLanguage;
        this.forceMel = Boolean.valueOf(System.getProperty("mule.test.mel.default", "false")) != false || !dataWeaveExpressionLanguage.isEnabled();
    }

    public boolean isForceMel() {
        return this.forceMel;
    }

    @Override
    public void registerGlobalContext(BindingContext bindingContext) {
        this.dataWeaveExpressionLanguage.registerGlobalContext(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, flowConstruct, bindingContext);
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.selectExpressionLanguage(expression).validate(expression);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, eventBuilder, flowConstruct, bindingContext);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, flowConstruct, object);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, flowConstruct, value);
    }

    private ExtendedExpressionLanguage selectExpressionLanguage(String expression) {
        if (this.isMelExpression(expression) || this.forceMel) {
            return this.mvelExpressionLanguage;
        }
        return this.dataWeaveExpressionLanguage;
    }

    protected boolean isMelExpression(String expression) {
        return expression.startsWith("#[mel:") || expression.startsWith("mel:");
    }
}

