/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.DefaultValidationResult;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguage;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.el.GlobalBindingContextProvider;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.el.DataWeaveExpressionLanguage;
import org.mule.runtime.core.el.ExtendedExpressionLanguageAdapter;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.util.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionManager
implements ExtendedExpressionManager,
Initialisable {
    public static final String MEL_PREFIX = "mel:";
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpressionManager.class);
    private MuleContext muleContext;
    private ExtendedExpressionLanguage expressionLanguage;
    private TemplateParser parser = TemplateParser.createMuleStyleParser();
    private boolean forceMel;

    @Inject
    public DefaultExpressionManager(MuleContext muleContext) {
        this.muleContext = muleContext;
        DataWeaveExpressionLanguage dataWeaveExpressionLanguage = new DataWeaveExpressionLanguage(muleContext.getExecutionClassLoader());
        MVELExpressionLanguage mvelExpressionLanguage = (MVELExpressionLanguage)muleContext.getRegistry().lookupObject("_muleExpressionLanguage");
        this.expressionLanguage = new ExtendedExpressionLanguageAdapter(dataWeaveExpressionLanguage, mvelExpressionLanguage);
        this.forceMel = ((ExtendedExpressionLanguageAdapter)this.expressionLanguage).isForceMel();
    }

    public void initialise() throws InitialisationException {
        Collection<GlobalBindingContextProvider> contextProviders = this.muleContext.getRegistry().lookupObjects(GlobalBindingContextProvider.class);
        for (GlobalBindingContextProvider contextProvider : contextProviders) {
            this.expressionLanguage.registerGlobalContext(contextProvider.getBindingContext());
        }
    }

    @Override
    public TypedValue evaluate(String expression) {
        return this.evaluate(expression, BindingContext.builder().build());
    }

    @Override
    public TypedValue evaluate(String expression, Event event) {
        return this.evaluate(expression, event, BindingContext.builder().build());
    }

    @Override
    public TypedValue evaluate(String expression, BindingContext context) {
        return this.evaluate(expression, null, null, null, context);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) {
        return this.evaluate(expression, event, Event.builder(event), null, context);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct) {
        return this.evaluate(expression, event, Event.builder(event), flowConstruct, BindingContext.builder().build());
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct) {
        return this.evaluate(expression, event, eventBuilder, flowConstruct, BindingContext.builder().build());
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext context) {
        return this.evaluate(expression, event, Event.builder(event), flowConstruct, context);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext context) {
        return this.expressionLanguage.evaluate(expression, event, eventBuilder, flowConstruct, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType) {
        return this.evaluate(expression, outputType, BindingContext.builder().build());
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType, BindingContext context) {
        return this.evaluate(expression, outputType, context, null);
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType, BindingContext context, Event event) {
        TypedValue result = this.evaluate(expression, event, null, null, context);
        DataType sourceType = result.getDataType();
        try {
            return this.transform(result, sourceType, outputType);
        }
        catch (TransformerException e) {
            throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to apply implicit transformation from type %s to %s", sourceType, outputType), (Object[])new Object[]{e}));
        }
    }

    private TypedValue transform(TypedValue target, DataType sourceType, DataType outputType) throws TransformerException {
        Object result = this.muleContext.getRegistry().lookupTransformer(sourceType, outputType).transform(target.getValue());
        return new TypedValue(result, outputType);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        this.expressionLanguage.enrich(expression, event, eventBuilder, flowConstruct, object);
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        this.expressionLanguage.enrich(expression, event, eventBuilder, flowConstruct, value);
    }

    @Override
    public boolean evaluateBoolean(String expression, Event event, FlowConstruct flowConstruct) throws ExpressionRuntimeException {
        return this.evaluateBoolean(expression, event, flowConstruct, false, false);
    }

    @Override
    public boolean evaluateBoolean(String expression, Event event, FlowConstruct flowConstruct, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        return this.resolveBoolean(this.evaluate(expression, event, flowConstruct).getValue(), nullReturnsTrue, nonBooleanReturnsTrue, expression);
    }

    protected boolean resolveBoolean(Object result, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue, String expression) {
        if (result == null) {
            return nullReturnsTrue;
        }
        Object value = result;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (value.toString().toLowerCase().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().toLowerCase().equalsIgnoreCase("true")) {
                return true;
            }
            return nonBooleanReturnsTrue;
        }
        logger.warn("Expression: " + expression + ", returned an non-boolean result. Returning: " + nonBooleanReturnsTrue);
        return nonBooleanReturnsTrue;
    }

    @Override
    public String parse(String expression, Event event, FlowConstruct flowConstruct) throws ExpressionRuntimeException {
        return this.parse(expression, event, Event.builder(event), flowConstruct);
    }

    @Override
    public String parse(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct) throws ExpressionRuntimeException {
        logger.warn("Expression parsing is deprecated, regular evaluations should be used instead.");
        if (this.hasMelExpression(expression) || this.forceMel) {
            return this.parser.parse(token -> {
                Object result = this.evaluate(token, event, eventBuilder, flowConstruct).getValue();
                if (result instanceof InternalMessage) {
                    return ((InternalMessage)result).getPayload().getValue();
                }
                return result;
            }, expression);
        }
        if (this.isExpression(expression)) {
            TypedValue evaluation = this.evaluate(expression, event, eventBuilder, flowConstruct);
            try {
                return (String)this.transform(evaluation, evaluation.getDataType(), DataType.STRING).getValue();
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to transform %s to %s.", evaluation.getDataType(), DataType.STRING)), (Throwable)((Object)e));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("No expression marker found in expression '%s'. Parsing as plain String.", expression));
        }
        return expression;
    }

    @Override
    public boolean isExpression(String expression) {
        return expression.contains("#[");
    }

    @Override
    public boolean isValid(String expression) {
        return this.validate(expression).isSuccess();
    }

    @Override
    public ValidationResult validate(String expression) {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Validate expressions is turned off, no checking done for: " + expression);
            }
            return new DefaultValidationResult(true, null);
        }
        StringBuilder message = new StringBuilder();
        try {
            this.parser.validate(expression);
            AtomicBoolean valid = new AtomicBoolean(true);
            if (!expression.contains("#[")) {
                return this.expressionLanguage.validate(expression);
            }
            this.parser.parse(token -> {
                ValidationResult result;
                if (valid.get() && !(result = this.expressionLanguage.validate(token)).isSuccess()) {
                    valid.compareAndSet(true, false);
                    message.append(token).append(" is invalid\n");
                    message.append(result.errorMessage().orElse(""));
                }
                return null;
            }, expression);
        }
        catch (IllegalArgumentException e) {
            return ValidationResult.failure((String)e.getMessage(), (String)expression);
        }
        if (message.length() > 0) {
            return ValidationResult.failure((String)message.toString());
        }
        return ValidationResult.success();
    }

    private boolean hasMelExpression(String expression) {
        return expression.contains("#[mel:");
    }
}

