/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionExecutor;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguage;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWeaveExpressionLanguage
implements ExtendedExpressionLanguage {
    private static final Logger logger = LoggerFactory.getLogger(DataWeaveExpressionLanguage.class);
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String VARIABLES = "variables";
    public static final String FLOW = "flow";
    private ExpressionExecutor expressionExecutor;
    private BindingContext globalBindingContext;
    private boolean enabled;

    public DataWeaveExpressionLanguage(ClassLoader lookupClassloader) {
        Iterator<ExpressionExecutor> executors = ServiceLoader.load(ExpressionExecutor.class, lookupClassloader).iterator();
        if (executors.hasNext()) {
            try {
                this.expressionExecutor = executors.next();
                this.enabled = true;
            }
            catch (Throwable e) {
                logger.warn("DW Executor could not be loaded. MEL will be the default EL.");
                this.enabled = false;
            }
        }
        this.globalBindingContext = BindingContext.builder().build();
    }

    @Override
    public synchronized void registerGlobalContext(BindingContext bindingContext) {
        this.expressionExecutor.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        return this.evaluate(expression, contextBuilder.build());
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, flowConstruct, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext context) {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        this.addFlowBindings(flowConstruct, contextBuilder);
        return this.evaluate(expression, contextBuilder.build());
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(this.sanitize(expression));
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private TypedValue evaluate(String expression, BindingContext context) {
        try {
            return this.expressionExecutor.evaluate(this.sanitize(expression), context);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
        }
    }

    private BindingContext.Builder addFlowBindings(FlowConstruct flow, BindingContext.Builder contextBuilder) {
        if (flow != null) {
            contextBuilder.addBinding(FLOW, new TypedValue((Object)new FlowVariablesAccessor(flow.getName()), DataType.fromType(FlowVariablesAccessor.class)));
        }
        return contextBuilder;
    }

    private void addEventBindings(Event event, BindingContext.Builder contextBuilder) {
        if (event != null) {
            HashMap flowVars = new HashMap();
            event.getVariableNames().forEach(name -> {
                TypedValue value = event.getVariable((String)name);
                flowVars.put(name, value);
                contextBuilder.addBinding(name, value);
            });
            contextBuilder.addBinding(VARIABLES, new TypedValue(Collections.unmodifiableMap(flowVars), DataType.fromType(flowVars.getClass())));
            InternalMessage message = event.getMessage();
            Attributes attributes = message.getAttributes();
            contextBuilder.addBinding(ATTRIBUTES, new TypedValue((Object)attributes, DataType.fromType(attributes.getClass())));
            contextBuilder.addBinding(PAYLOAD, message.getPayload());
            contextBuilder.addBinding(DATA_TYPE, new TypedValue((Object)message.getPayload().getDataType(), DataType.fromType(DataType.class)));
            Error error = event.getError().isPresent() ? event.getError().get() : null;
            contextBuilder.addBinding(ERROR, new TypedValue((Object)error, DataType.fromType(Error.class)));
        }
    }

    private BindingContext.Builder bindingContextBuilderFor(Event event, BindingContext context) {
        BindingContext.Builder contextBuilder = BindingContext.builder((BindingContext)context);
        this.addEventBindings(event, contextBuilder);
        return contextBuilder;
    }

    private String sanitize(String expression) {
        String sanitizedExpression = expression.startsWith("#[") ? expression.substring("#[".length(), expression.length() - "]".length()) : expression;
        return sanitizedExpression;
    }

    private class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

