/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.SynchronousServerEvent;
import org.mule.runtime.core.api.message.InternalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorMessageNotification
extends ServerNotification
implements SynchronousServerEvent {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Logger logger = LoggerFactory.getLogger(ConnectorMessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_RESPONSE = 805;
    public static final int MESSAGE_ERROR_RESPONSE = 806;
    public static final int MESSAGE_REQUEST_BEGIN = 804;
    public static final int MESSAGE_REQUEST_END = 853;
    private final Object component;
    private String endpoint;
    private FlowConstruct flowConstruct;

    public ConnectorMessageNotification(Object component, InternalMessage resource, String endpoint, FlowConstruct flowConstruct, int action) {
        super(resource, action, flowConstruct != null ? flowConstruct.getName() : null);
        this.component = component;
        this.endpoint = endpoint;
        this.flowConstruct = flowConstruct;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + ConnectorMessageNotification.getActionName(this.action) + ", endpoint: " + this.endpoint + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public String getType() {
        return "trace";
    }

    @Override
    public InternalMessage getSource() {
        return (InternalMessage)super.getSource();
    }

    public Object getComponent() {
        return this.component;
    }

    static {
        ConnectorMessageNotification.registerAction("receive", 801);
        ConnectorMessageNotification.registerAction("response", 805);
        ConnectorMessageNotification.registerAction("error response", 806);
        ConnectorMessageNotification.registerAction("begin request", 804);
        ConnectorMessageNotification.registerAction("end request", 853);
    }
}

