/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.util.Collections;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.registry.ServiceException;
import org.mule.runtime.core.component.AbstractJavaComponent;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.VoidResult;
import org.mule.runtime.core.object.SingletonObjectFactory;
import org.mule.runtime.core.transformer.TransformerTemplate;

public class SimpleCallableJavaComponent
extends AbstractJavaComponent {
    private boolean started = false;

    public SimpleCallableJavaComponent() {
    }

    public SimpleCallableJavaComponent(Callable callable) {
        this.objectFactory = new SingletonObjectFactory(callable);
    }

    public SimpleCallableJavaComponent(Class callable) throws DefaultMuleException {
        if (!Callable.class.isAssignableFrom(callable)) {
            throw new DefaultMuleException(CoreMessages.objectNotOfCorrectType(callable, Callable.class));
        }
        this.objectFactory = new SingletonObjectFactory(callable);
    }

    public SimpleCallableJavaComponent(ObjectFactory objectFactory) throws DefaultMuleException {
        if (!Callable.class.isAssignableFrom(objectFactory.getObjectClass())) {
            throw new DefaultMuleException(CoreMessages.objectNotOfCorrectType(objectFactory.getObjectClass(), Callable.class));
        }
        this.objectFactory = objectFactory;
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        if (Startable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Startable)this.objectFactory.getInstance(this.muleContext)).start();
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToStart("Service '" + this.flowConstruct.getName() + "'"), e);
            }
        }
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        if (this.started && Stoppable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Stoppable)this.objectFactory.getInstance(this.muleContext)).stop();
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToStop("Service '" + this.flowConstruct.getName() + "'"), e);
            }
        }
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        if (Disposable.class.isAssignableFrom(this.objectFactory.getObjectClass())) {
            try {
                ((Disposable)this.objectFactory.getInstance(this.muleContext)).dispose();
            }
            catch (Exception e) {
                this.logger.error("Unable to dispose component instance", (Throwable)e);
            }
        }
    }

    public Class getObjectType() {
        if (this.objectFactory != null) {
            return this.objectFactory.getObjectClass();
        }
        return Callable.class;
    }

    @Override
    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        return null;
    }

    @Override
    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) {
    }

    @Override
    protected Object invokeComponentInstance(Event event, Event.Builder eventBuilder) throws Exception {
        Object result = ((Callable)this.objectFactory.getInstance(this.muleContext)).onCall(new DefaultMuleEventContext(this.flowConstruct, event));
        if (result instanceof VoidResult) {
            return event.getMessage();
        }
        if (result != null) {
            if (result instanceof InternalMessage) {
                return result;
            }
            return this.muleContext.getTransformationService().applyTransformers(event.getMessage(), event, Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
        }
        return null;
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        if (!Callable.class.isAssignableFrom(objectFactory.getObjectClass())) {
            throw new MuleRuntimeException(CoreMessages.objectNotOfCorrectType(objectFactory.getObjectClass(), Callable.class));
        }
        super.setObjectFactory(objectFactory);
    }
}

