/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.scheduler;

import java.util.Objects;

public class SchedulerConfig {
    private Integer maxConcurrentTasks;
    private String schedulerName;
    private RejectionAction rejectionAction = RejectionAction.DEFAULT;

    public static SchedulerConfig config() {
        return new SchedulerConfig();
    }

    public SchedulerConfig withMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
        return this;
    }

    public Integer getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public SchedulerConfig withName(String schedulerName) {
        this.schedulerName = schedulerName;
        return this;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public SchedulerConfig withRejectionAction(RejectionAction rejectionAction) {
        Objects.requireNonNull(rejectionAction);
        this.rejectionAction = rejectionAction;
        return this;
    }

    public RejectionAction getRejectionAction() {
        return this.rejectionAction;
    }

    public static enum RejectionAction {
        DEFAULT,
        WAIT;

    }
}

