/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.routing;

import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;

public final class AggregationContext {
    private static final Predicate failedEventsPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            Event event = (Event)object;
            return event.getError().isPresent();
        }
    };
    private final Event originalEvent;
    private final List<Event> events;

    public AggregationContext(Event originalEvent, List<Event> events) {
        Preconditions.checkArgument((events != null ? 1 : 0) != 0, (String)"events cannot be null");
        this.originalEvent = originalEvent;
        this.events = Collections.unmodifiableList(events);
    }

    public List<Event> collectEventsWithExceptions() {
        return (List)CollectionUtils.select(this.events, (Predicate)failedEventsPredicate);
    }

    public NavigableMap<Integer, Throwable> collectRouteExceptions() {
        TreeMap<Integer, Throwable> routes = new TreeMap<Integer, Throwable>();
        for (int i = 0; i < this.events.size(); ++i) {
            Event event = this.events.get(i);
            if (!failedEventsPredicate.evaluate((Object)event)) continue;
            routes.put(i, event.getError().get().getCause());
        }
        return routes;
    }

    public List<Event> collectEventsWithoutExceptions() {
        return (List)CollectionUtils.selectRejected(this.events, (Predicate)failedEventsPredicate);
    }

    public Event getOriginalEvent() {
        return this.originalEvent;
    }

    public List<Event> getEvents() {
        return this.events;
    }
}

