/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.interception;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;

public class DefaultInterceptionEvent
implements InterceptionEvent {
    private Event interceptedInput;
    private Event.Builder interceptedOutput;

    public DefaultInterceptionEvent(Event interceptedInput) {
        this.interceptedInput = interceptedInput;
        this.interceptedOutput = Event.builder(interceptedInput);
    }

    public Message getMessage() {
        return this.interceptedInput.getMessage();
    }

    public <T> TypedValue<T> getVariable(String key) {
        return this.interceptedInput.getVariable(key);
    }

    public Set<String> getVariableNames() {
        return this.interceptedInput.getVariableNames();
    }

    public Optional<Error> getError() {
        return this.interceptedInput.getError();
    }

    public DefaultInterceptionEvent message(Message message) {
        this.interceptedOutput = this.interceptedOutput.message(message);
        return this;
    }

    public DefaultInterceptionEvent variables(Map<String, Object> variables) {
        this.interceptedOutput = this.interceptedOutput.variables(variables);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value, DataType mediaType) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value, mediaType);
        return this;
    }

    public DefaultInterceptionEvent removeVariable(String key) {
        this.interceptedOutput = this.interceptedOutput.removeVariable(key);
        return this;
    }

    public Event resolve() {
        this.interceptedInput = this.interceptedOutput.build();
        this.interceptedOutput = Event.builder(this.interceptedInput);
        return this.interceptedInput;
    }

    public Event getInterceptionResult() {
        return this.interceptedInput;
    }
}

