/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.config.spring.DefaultCustomizationService;
import org.mule.runtime.core.api.CustomizationService;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.client.MuleClient;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.connector.PollingController;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.interception.ProcessorInterceptorProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.locator.ConfigurationComponentLocator;
import org.mule.runtime.core.api.lock.LockFactory;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.config.ClusterConfiguration;
import org.mule.runtime.core.config.NullClusterConfiguration;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.NotificationException;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.DefaultMessagingExceptionStrategy;
import org.mule.runtime.core.exception.DefaultSystemExceptionStrategy;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.client.DefaultLocalMuleClient;
import org.mule.runtime.core.internal.connector.DefaultPollingController;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.management.stats.AllStatistics;
import org.mule.runtime.core.management.stats.ProcessingTimeWatcher;
import org.mule.runtime.core.registry.DefaultRegistryBroker;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.core.util.ApplicationShutdownSplashScreen;
import org.mule.runtime.core.util.ApplicationStartupSplashScreen;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.core.util.JdkVersionUtils;
import org.mule.runtime.core.util.ServerShutdownSplashScreen;
import org.mule.runtime.core.util.ServerStartupSplashScreen;
import org.mule.runtime.core.util.SplashScreen;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.core.util.concurrent.Latch;
import org.mule.runtime.core.util.queue.QueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Hooks;

public class DefaultMuleContext
implements MuleContext {
    public static final String LOCAL_TRANSIENT_OBJECT_STORE_KEY = "_localInMemoryObjectStore";
    public static final String LOCAL_PERSISTENT_OBJECT_STORE_KEY = "_localPersistentObjectStore";
    public static final String LOCAL_OBJECT_STORE_MANAGER_KEY = "_localObjectStoreManager";
    public static final String LOCAL_QUEUE_MANAGER_KEY = "_localQueueManager";
    private static Logger logger = LoggerFactory.getLogger(DefaultMuleContext.class);
    private CustomizationService customizationService = new DefaultCustomizationService();
    private DefaultRegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private Injector injector;
    private AllStatistics stats = new AllStatistics();
    private volatile SchedulerService schedulerService;
    protected MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;
    private volatile StreamCloserService streamCloserService;
    private Object streamCloserServiceLock = new Object();
    private ClassLoader executionClassLoader;
    protected MuleClient localMuleClient;
    protected SystemExceptionHandler exceptionListener;
    private PollingController pollingController = new DefaultPollingController();
    private ClusterConfiguration clusterConfiguration = new NullClusterConfiguration();
    private Map<QName, Set<Object>> configurationAnnotations = new HashMap<QName, Set<Object>>();
    private SingleResourceTransactionFactoryManager singleResourceTransactionFactoryManager = new SingleResourceTransactionFactoryManager();
    private LockFactory lockFactory;
    private ExtendedExpressionManager expressionManager;
    private ProcessingTimeWatcher processingTimeWatcher;
    private final Latch startLatch = new Latch();
    private QueueManager queueManager;
    private ExtensionManager extensionManager;
    private ObjectSerializer objectSerializer;
    private volatile DataTypeConversionResolver dataTypeConversionResolver;
    private Object dataTypeConversionResolverLock = new Object();
    private volatile FlowTraceManager flowTraceManager;
    private Object flowTraceManagerLock = new Object();
    private volatile Collection<ExceptionContextProvider> exceptionContextProviders;
    private Object exceptionContextProvidersLock = new Object();
    private TransformationService transformationService;
    private BootstrapServiceDiscoverer bootstrapServiceDiscoverer;
    private ArtifactType artifactType;
    private ErrorTypeLocator errorTypeLocator;
    private ErrorTypeRepository errorTypeRepository;
    private ProcessorInterceptorProvider processorInterceptorManager;

    @Deprecated
    public DefaultMuleContext(MuleConfiguration config, MuleContextLifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        ((MuleContextAware)((Object)config)).setMuleContext(this);
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
        this.notificationManager.setMuleContext(this);
        this.registryBroker = this.createRegistryBroker();
        this.muleRegistryHelper = this.createRegistryHelper(this.registryBroker);
        this.localMuleClient = new DefaultLocalMuleClient(this);
        this.exceptionListener = new DefaultSystemExceptionStrategy();
        this.transformationService = new TransformationService(this);
    }

    public DefaultMuleContext() {
        this.transformationService = new TransformationService(this);
    }

    protected DefaultRegistryBroker createRegistryBroker() {
        return new DefaultRegistryBroker(this);
    }

    protected MuleRegistry createRegistryHelper(DefaultRegistryBroker registry) {
        return new MuleRegistryHelper(registry, this);
    }

    public synchronized void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
        }
        try {
            JdkVersionUtils.validateJdk();
        }
        catch (RuntimeException e) {
            throw new InitialisationException(CoreMessages.invalidJdk(SystemUtils.JAVA_VERSION, JdkVersionUtils.getSupportedJdks()), (Initialisable)this);
        }
        try {
            this.getRegistry().initialise();
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.getLifecycleManager().fireLifecycle("initialise");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
            LifecycleUtils.initialiseIfNeeded(this.getExceptionListener(), (MuleContext)this);
            this.getNotificationManager().initialise();
        }
        catch (InitialisationException e) {
            this.disposeManagers();
            throw e;
        }
        catch (Exception e) {
            this.disposeManagers();
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void start() throws MuleException {
        this.getLifecycleManager().checkPhase("start");
        if (this.getQueueManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
        }
        this.startDate = System.currentTimeMillis();
        LifecycleUtils.startIfNeeded(this.extensionManager);
        this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
        this.getLifecycleManager().fireLifecycle("start");
        this.overridePollingController();
        this.overrideClusterConfiguration();
        this.startMessageSources();
        this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
        this.startLatch.release();
        if (logger.isInfoEnabled()) {
            SplashScreen startupScreen = this.buildStartupSplash();
            logger.info(startupScreen.toString());
        }
    }

    private void startMessageSources() throws LifecycleException {
        this.startPipelineMessageSources();
    }

    private void startPipelineMessageSources() throws LifecycleException {
        for (Pipeline pipeline : this.getRegistry().lookupObjects(Pipeline.class)) {
            if (!pipeline.getLifecycleState().isStarted()) continue;
            MessageSource messageSource = pipeline.getMessageSource();
            this.startMessageSource(messageSource);
        }
    }

    private void startMessageSource(MessageSource messageSource) throws LifecycleException {
        try {
            LifecycleUtils.startIfNeeded(messageSource);
        }
        catch (ConnectException e) {
            this.exceptionListener.handleException((Exception)((Object)e));
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e, (Object)messageSource);
        }
    }

    public synchronized void stop() throws MuleException {
        this.startLatch.release();
        LifecycleUtils.stopIfNeeded(this.extensionManager);
        this.getLifecycleManager().checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.getLifecycleManager().fireLifecycle("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    public synchronized void dispose() {
        if (this.isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                logger.error("Failed to stop Mule context", (Throwable)e);
            }
        }
        this.getLifecycleManager().checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        LifecycleUtils.disposeIfNeeded(this.getExceptionListener(), logger);
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
            this.muleRegistryHelper.dispose();
        }
        catch (Exception e) {
            logger.debug("Failed to cleanly dispose Mule: " + e.getMessage(), (Throwable)e);
        }
        this.notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        this.disposeManagers();
        if (this.getStartDate() > 0L && logger.isInfoEnabled()) {
            SplashScreen shutdownScreen = this.buildShutdownSplash();
            logger.info(shutdownScreen.toString());
        }
        this.setExecutionClassLoader(null);
    }

    private void disposeManagers() {
        this.notificationManager.dispose();
    }

    @Override
    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    @Override
    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    @Override
    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    @Override
    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    @Override
    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    @Override
    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    @Override
    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public AllStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    @Override
    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    @Override
    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug("MuleEvent Manager is not enabled, ignoring notification: " + notification);
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.registryBroker.registerObject("_muleSecurityManager", securityManager);
    }

    @Override
    public SecurityManager getSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.registryBroker.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.registryBroker.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        if (securityManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        return securityManager;
    }

    @Override
    public SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            try {
                this.schedulerService = this.getRegistry().lookupObject(SchedulerService.class);
                Objects.requireNonNull(this.schedulerService);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)((Object)e));
            }
        }
        return this.schedulerService;
    }

    @Override
    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            Collection<QueueManager> temp;
            this.queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
            if (this.queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
                this.queueManager = temp.iterator().next();
            }
        }
        return this.queueManager;
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public ObjectStoreManager getObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public ObjectStoreManager getLocalObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject(LOCAL_OBJECT_STORE_MANAGER_KEY);
    }

    public QueueManager getLocalQueueManager() {
        return (QueueManager)this.getRegistry().lookupObject(LOCAL_QUEUE_MANAGER_KEY);
    }

    @Override
    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.getRegistry().registerObject("_muleQueueManager", queueManager);
        this.queueManager = queueManager;
    }

    @Override
    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.getRegistry().lookupObject("_muleTransactionManager");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has already been through the " + phase + " phase.");
        }
    }

    @Override
    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamCloserService getStreamCloserService() {
        if (this.streamCloserService == null) {
            Object object = this.streamCloserServiceLock;
            synchronized (object) {
                if (this.streamCloserService == null) {
                    this.streamCloserService = (StreamCloserService)this.getRegistry().lookupObject("_muleStreamCloserService");
                }
            }
        }
        return this.streamCloserService;
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    @Override
    @Deprecated
    public void addRegistry(Registry registry) {
        this.registryBroker.addRegistry(registry);
    }

    @Override
    @Deprecated
    public void removeRegistry(Registry registry) {
        this.registryBroker.removeRegistry(registry);
    }

    protected SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ApplicationStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    protected SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ApplicationShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    @Override
    public MuleClient getClient() {
        return this.localMuleClient;
    }

    @Override
    public void handleException(Exception e, RollbackSourceCallback rollbackMethod) {
        this.getExceptionListener().handleException(e, rollbackMethod);
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(e, null);
    }

    @Override
    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void setObjectStore(String name, ListableObjectStore<Serializable> store) throws RegistrationException {
        this.checkLifecycleForPropertySet(name, "initialise");
        this.registryBroker.registerObject(name, store);
    }

    @Override
    public String getClusterId() {
        return this.clusterConfiguration.getClusterId();
    }

    @Override
    public int getClusterNodeId() {
        return this.clusterConfiguration.getClusterNodeId();
    }

    public void setPollingController(PollingController pollingController) {
        this.pollingController = pollingController;
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.pollingController.isPrimaryPollingInstance();
    }

    @Override
    public String getUniqueIdString() {
        return this.clusterConfiguration.getClusterNodeId() + "-" + UUID.getUUID();
    }

    @Override
    public Map<QName, Set<Object>> getConfigurationAnnotations() {
        return this.configurationAnnotations;
    }

    @Override
    public MessagingExceptionHandler getDefaultErrorHandler() {
        MessagingExceptionHandler defaultExceptionStrategy;
        if (this.config.getDefaultErrorHandlerName() != null) {
            defaultExceptionStrategy = (MessagingExceptionHandler)this.getRegistry().lookupObject(this.config.getDefaultErrorHandlerName());
            if (defaultExceptionStrategy == null) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("No global error handler named %s", this.config.getDefaultErrorHandlerName())));
            }
        } else {
            defaultExceptionStrategy = new DefaultMessagingExceptionStrategy(this);
        }
        return defaultExceptionStrategy;
    }

    @Override
    public SingleResourceTransactionFactoryManager getTransactionFactoryManager() {
        return this.singleResourceTransactionFactoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeConversionResolver getDataTypeConverterResolver() {
        if (this.dataTypeConversionResolver == null) {
            Object object = this.dataTypeConversionResolverLock;
            synchronized (object) {
                if (this.dataTypeConversionResolver == null) {
                    this.dataTypeConversionResolver = (DataTypeConversionResolver)this.getRegistry().lookupObject("_converterResolver");
                    if (this.dataTypeConversionResolver == null) {
                        this.dataTypeConversionResolver = new DynamicDataTypeConversionResolver(this);
                        try {
                            this.getRegistry().registerObject("_converterResolver", this.dataTypeConversionResolver);
                        }
                        catch (RegistrationException e) {
                            throw new IllegalStateException((Throwable)((Object)e));
                        }
                    }
                }
            }
        }
        return this.dataTypeConversionResolver;
    }

    @Override
    public ExtendedExpressionManager getExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = (ExtendedExpressionManager)this.registryBroker.lookupObject("_muleExpressionManager");
        }
        return this.expressionManager;
    }

    @Override
    public LockFactory getLockFactory() {
        if (this.lockFactory == null) {
            this.lockFactory = (LockFactory)this.registryBroker.get("_muleLockFactory");
        }
        return this.lockFactory;
    }

    @Override
    public ProcessingTimeWatcher getProcessorTimeWatcher() {
        if (this.processingTimeWatcher == null) {
            this.processingTimeWatcher = (ProcessingTimeWatcher)this.registryBroker.get("_muleProcessingTimeWatcher");
        }
        return this.processingTimeWatcher;
    }

    @Override
    public boolean waitUntilStarted(int timeout) throws InterruptedException {
        return this.startLatch.await(timeout, TimeUnit.MILLISECONDS);
    }

    private void overrideClusterConfiguration() {
        ClusterConfiguration overriddenClusterConfiguration = (ClusterConfiguration)this.getRegistry().get("_muleClusterConfiguration");
        if (overriddenClusterConfiguration != null) {
            this.clusterConfiguration = overriddenClusterConfiguration;
        }
    }

    private void overridePollingController() {
        PollingController overriddenPollingController = (PollingController)this.getRegistry().get("_mulePollingController");
        if (overriddenPollingController != null) {
            this.pollingController = overriddenPollingController;
        }
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.config = muleConfiguration;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setLifecycleManager(MuleContextLifecycleManager lifecyleManager) {
        this.lifecycleManager = lifecyleManager;
    }

    public void setRegistryBroker(DefaultRegistryBroker registryBroker) {
        this.registryBroker = registryBroker;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setMuleRegistry(MuleRegistryHelper muleRegistry) {
        this.muleRegistryHelper = muleRegistry;
    }

    public void setLocalMuleClient(MuleClient muleClient) {
        this.localMuleClient = muleClient;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowTraceManager getFlowTraceManager() {
        if (this.flowTraceManager == null) {
            Object object = this.flowTraceManagerLock;
            synchronized (object) {
                if (this.flowTraceManager == null) {
                    try {
                        this.flowTraceManager = this.getRegistry().lookupObject(FlowTraceManager.class);
                    }
                    catch (RegistrationException e) {
                        throw new IllegalStateException((Throwable)((Object)e));
                    }
                }
            }
        }
        return this.flowTraceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExceptionContextProvider> getExceptionContextProviders() {
        if (this.exceptionContextProviders == null) {
            Object object = this.exceptionContextProvidersLock;
            synchronized (object) {
                if (this.exceptionContextProviders == null) {
                    this.exceptionContextProviders = this.muleRegistryHelper.lookupByType(ExceptionContextProvider.class).values();
                }
            }
        }
        return this.exceptionContextProviders;
    }

    @Override
    public TransformationService getTransformationService() {
        return this.transformationService;
    }

    @Override
    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    @Override
    public BootstrapServiceDiscoverer getRegistryBootstrapServiceDiscoverer() {
        return this.bootstrapServiceDiscoverer;
    }

    @Override
    public CustomizationService getCustomizationService() {
        return this.customizationService;
    }

    @Override
    public void setBootstrapServiceDiscoverer(BootstrapServiceDiscoverer bootstrapServiceDiscoverer) {
        this.bootstrapServiceDiscoverer = bootstrapServiceDiscoverer;
    }

    @Override
    public ConfigurationComponentLocator getConfigurationComponentLocator() {
        return (ConfigurationComponentLocator)this.getRegistry().lookupObject("_muleConfigurationComponentLocator");
    }

    @Override
    public String getId() {
        MuleConfiguration conf = this.getConfiguration();
        return conf.getDomainId() + "." + this.getClusterId() + "." + conf.getId();
    }

    public void setErrorTypeLocator(ErrorTypeLocator errorTypeLocator) {
        this.errorTypeLocator = errorTypeLocator;
    }

    @Override
    public ErrorTypeLocator getErrorTypeLocator() {
        return this.errorTypeLocator;
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    @Override
    public ProcessorInterceptorProvider getProcessorInterceptorManager() {
        return this.processorInterceptorManager;
    }

    public void setProcessorInterceptorManager(ProcessorInterceptorProvider processorInterceptorManager) {
        this.processorInterceptorManager = processorInterceptorManager;
    }

    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    static {
        Hooks.onOperatorError((throwable, signal) -> {
            if (signal instanceof Event && !(throwable instanceof Exceptions.EventDroppedException)) {
                return (throwable = Exceptions.unwrap((Throwable)throwable)) instanceof MessagingException ? throwable : new MessagingException((Event)signal, ExceptionUtils.getRootCauseException(throwable));
            }
            return throwable;
        });
        Hooks.onErrorDropped(error -> logger.error("ERROR DROPPED UNEXPECTEDLY" + error));
        Hooks.onNextDropped(event -> logger.error("EVENT DROPPED UNEXPECTEDLY" + event));
    }
}

