/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.OffsetTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.core.AbstractEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.management.stats.ProcessingTime;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.MonoProcessor;

public final class DefaultEventContext
extends AbstractEventContext
implements Serializable {
    private static final long serialVersionUID = -3664490832964509653L;
    private transient MonoProcessor<Event> monoProcessor = MonoProcessor.create();
    private final String id;
    private final String correlationId;
    private final OffsetTime receivedDate = OffsetTime.now();
    private final String serverId;
    private final String flowName;
    private final String connectorName;
    private final ProcessingTime processingTime;
    private final ProcessorsTrace processorsTrace = new DefaultProcessorsTrace();

    public static EventContext create(FlowConstruct flow, String connectorName) {
        return DefaultEventContext.create(flow, connectorName, null);
    }

    public static EventContext create(FlowConstruct flow, String connectorName, String correlationId) {
        return new DefaultEventContext(flow, connectorName, correlationId);
    }

    public static EventContext child(EventContext parent) {
        ChildEventContext child = new ChildEventContext(parent);
        if (parent instanceof AbstractEventContext) {
            ((AbstractEventContext)parent).addChildContext(child);
        }
        return child;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? this.correlationId : this.id;
    }

    @Override
    public OffsetTime getReceivedTime() {
        return this.receivedDate;
    }

    @Override
    public String getOriginatingFlowName() {
        return this.flowName;
    }

    @Override
    public String getOriginatingConnectorName() {
        return this.connectorName;
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public boolean isCorrelationIdFromSource() {
        return this.correlationId != null;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return this.processorsTrace;
    }

    @Override
    public Optional<EventContext> getParentContext() {
        return Optional.empty();
    }

    private DefaultEventContext(FlowConstruct flow, String connectorName, String correlationId) {
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.flowName = flow.getName();
        this.connectorName = connectorName;
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
    }

    @Override
    protected void doSuccess() {
        this.monoProcessor.onComplete();
    }

    @Override
    protected void doSuccess(Event event) {
        this.monoProcessor.onNext((Object)event);
    }

    @Override
    protected void doError(Throwable messagingException) {
        this.monoProcessor.onError(messagingException);
    }

    public String toString() {
        return "DefaultMessageExecutionContext { id: " + this.id + "; correlationId: " + this.correlationId + "; flowName: " + this.flowName + "; serverId: " + this.serverId + " }";
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.monoProcessor = MonoProcessor.create();
    }

    public void subscribe(Subscriber<? super Event> s) {
        this.monoProcessor.subscribe(s);
    }

    private static class ChildEventContext
    extends AbstractEventContext
    implements Serializable {
        private static final long serialVersionUID = 1054412872901205234L;
        private transient MonoProcessor<Event> monoProcessor = MonoProcessor.create();
        private final EventContext parent;

        private ChildEventContext(EventContext parent) {
            this.parent = parent;
        }

        @Override
        public String getId() {
            return this.parent.getId() + System.identityHashCode(this);
        }

        @Override
        public String getCorrelationId() {
            return this.parent.getCorrelationId();
        }

        @Override
        public OffsetTime getReceivedTime() {
            return this.parent.getReceivedTime();
        }

        @Override
        public String getOriginatingFlowName() {
            return this.parent.getOriginatingFlowName();
        }

        @Override
        public String getOriginatingConnectorName() {
            return this.parent.getOriginatingConnectorName();
        }

        @Override
        public ProcessingTime getProcessingTime() {
            return this.parent.getProcessingTime();
        }

        @Override
        public ProcessorsTrace getProcessorsTrace() {
            return this.parent.getProcessorsTrace();
        }

        @Override
        public boolean isCorrelationIdFromSource() {
            return this.parent.isCorrelationIdFromSource();
        }

        @Override
        protected void doSuccess() {
            this.monoProcessor.onComplete();
        }

        @Override
        protected void doSuccess(Event event) {
            this.monoProcessor.onNext((Object)event);
        }

        @Override
        protected void doError(Throwable throwable) {
            this.monoProcessor.onError(throwable);
        }

        public String toString() {
            return this.parent.toString();
        }

        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.monoProcessor = MonoProcessor.create();
        }

        public void subscribe(Subscriber<? super Event> s) {
            this.monoProcessor.subscribe(s);
        }

        @Override
        public List<EventContext> getChildContexts() {
            return Collections.emptyList();
        }

        @Override
        public Optional<EventContext> getParentContext() {
            return Optional.of(this.parent);
        }
    }
}

