/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ComponentLocation;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageRouter;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.routing.SelectiveRouter;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public abstract class AbstractAnnotatedObject
implements AnnotatedObject {
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public final Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }

    public org.mule.runtime.api.component.ComponentIdentifier getIdentifier() {
        return new org.mule.runtime.api.component.ComponentIdentifier(){

            public String getNamespace() {
                return ((ComponentIdentifier)AbstractAnnotatedObject.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getNamespace();
            }

            public String getName() {
                return ((ComponentIdentifier)AbstractAnnotatedObject.this.getAnnotation(ComponentIdentifier.ANNOTATION_NAME)).getName();
            }

            public ComponentIdentifier.ComponentType getComponentType() {
                if (AbstractAnnotatedObject.this instanceof MessageSource) {
                    return ComponentIdentifier.ComponentType.SOURCE;
                }
                if (AbstractAnnotatedObject.this instanceof OutboundRouter || AbstractAnnotatedObject.this instanceof SelectiveRouter || AbstractAnnotatedObject.this instanceof MessageRouter) {
                    return ComponentIdentifier.ComponentType.ROUTER;
                }
                if (AbstractAnnotatedObject.this instanceof InterceptingMessageProcessor) {
                    return ComponentIdentifier.ComponentType.INTERCEPTING;
                }
                return ComponentIdentifier.ComponentType.PROCESSOR;
            }
        };
    }

    public ComponentLocation getLocation(final String flowPath) {
        if (flowPath == null) {
            return null;
        }
        return new ComponentLocation(){

            public String getPath() {
                return flowPath;
            }

            public Optional<String> getFileName() {
                return Optional.of((String)AbstractAnnotatedObject.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName")));
            }

            public Optional<Integer> getLineInFile() {
                return Optional.of(Integer.valueOf((Integer)AbstractAnnotatedObject.this.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine"))));
            }
        };
    }
}

