/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;
import org.mule.util.store.InMemoryObjectStore;

public class TextFileObjectStore
extends InMemoryObjectStore<String> {
    protected File fileStore;
    protected String directory;
    protected String encoding;
    private FileOutputStream output;

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.encoding == null) {
            this.encoding = this.context.getConfiguration().getDefaultEncoding();
        }
        if (this.directory == null) {
            this.directory = this.context.getConfiguration().getWorkingDirectory() + "/objectstore";
        }
        try {
            File dir = FileUtils.openDirectory(this.directory);
            this.fileStore = new File(dir, this.name + ".dat");
            if (this.fileStore.exists()) {
                this.loadFromStore();
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected synchronized void loadFromStore() throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(this.fileStore));
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            super.store((Serializable)((Object)entry.getKey().toString()), entry.getValue().toString());
        }
    }

    @Override
    public void store(Serializable id, String item) throws ObjectStoreException {
        super.store(id, item);
        try {
            if (this.output == null) {
                this.output = new FileOutputStream(this.fileStore, true);
            }
            this.updateTextFile();
        }
        catch (IOException iox) {
            throw new ObjectStoreException(iox);
        }
    }

    @Override
    public void expire() {
        int expiredEntries = this.doTrimAndExpire();
        if (expiredEntries > 0) {
            this.updateTextFile();
        }
        if (this.logger.isDebugEnabled() && expiredEntries != 0) {
            this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
        }
    }

    private void updateTextFile() {
        Properties props = this.getStoreAsProperties();
        try {
            if (this.output != null) {
                IOUtils.closeQuietly((OutputStream)this.output);
            }
            this.output = new FileOutputStream(this.fileStore, false);
            props.store(this.output, "");
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public synchronized void dispose() {
        Properties props = this.getStoreAsProperties();
        if (this.output == null) {
            try {
                this.output = new FileOutputStream(this.fileStore, false);
                props.store(this.output, "");
                IOUtils.closeQuietly((OutputStream)this.output);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            IOUtils.closeQuietly((OutputStream)this.output);
        }
        super.dispose();
    }

    private Properties getStoreAsProperties() {
        Properties props = new Properties();
        for (InMemoryObjectStore.StoredObject storedObject : this.store.values()) {
            props.put(storedObject.getId(), storedObject.getItem());
        }
        return props;
    }
}

