/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.journal.queue.LocalTxQueueTransactionRecoverer;
import org.mule.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.util.queue.AbstractQueueManager;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.QueueXaResourceManager;
import org.mule.util.queue.RecoverableQueueStore;
import org.mule.util.queue.TransactionalQueueSession;
import org.mule.util.xa.XaTransactionRecoverer;

public class TransactionalQueueManager
extends AbstractQueueManager {
    private LocalTxQueueTransactionJournal localTxTransactionJournal;
    private LocalTxQueueTransactionRecoverer localTxQueueTransactionRecoverer;
    private XaTxQueueTransactionJournal xaTransactionJournal;
    private XaTransactionRecoverer xaTransactionRecoverer;
    private QueueXaResourceManager queueXaResourceManager = new QueueXaResourceManager();
    private Map<String, RecoverableQueueStore> queuesAccessedForRecovery = new HashMap<String, RecoverableQueueStore>();

    @Override
    public synchronized QueueSession getQueueSession() {
        return new TransactionalQueueSession(this, this.queueXaResourceManager, this.queueXaResourceManager, this.xaTransactionRecoverer, this.localTxTransactionJournal, this.getMuleContext());
    }

    @Override
    protected DefaultQueueStore createQueueStore(String name, QueueConfiguration config) {
        return new DefaultQueueStore(name, this.getMuleContext(), config);
    }

    @Override
    protected void doDispose() {
        this.localTxTransactionJournal.close();
        this.xaTransactionJournal.close();
    }

    @Override
    public void initialise() throws InitialisationException {
        String workingDirectory = this.getMuleContext().getConfiguration().getWorkingDirectory();
        int queueTransactionFilesSizeInMegabytes = this.getMuleContext().getConfiguration().getMaxQueueTransactionFilesSizeInMegabytes();
        this.localTxTransactionJournal = new LocalTxQueueTransactionJournal(workingDirectory + File.separator + "queue-tx-log", this.getMuleContext(), (Integer)queueTransactionFilesSizeInMegabytes);
        this.localTxQueueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(this.localTxTransactionJournal, this);
        this.xaTransactionJournal = new XaTxQueueTransactionJournal(workingDirectory + File.separator + "queue-xa-tx-log", this.getMuleContext(), (Integer)queueTransactionFilesSizeInMegabytes);
        this.xaTransactionRecoverer = new XaTransactionRecoverer(this.xaTransactionJournal, this);
    }

    @Override
    public RecoverableQueueStore getRecoveryQueue(String queueName) {
        if (this.queuesAccessedForRecovery.containsKey(queueName)) {
            return this.queuesAccessedForRecovery.get(queueName);
        }
        DefaultQueueStore queueStore = this.createQueueStore(queueName, new DefaultQueueConfiguration(0, true));
        this.queuesAccessedForRecovery.put(queueName, queueStore);
        return queueStore;
    }

    @Override
    public void start() throws MuleException {
        this.queueXaResourceManager.start();
        this.localTxQueueTransactionRecoverer.recover();
        for (QueueStore queueStore : this.queuesAccessedForRecovery.values()) {
            queueStore.close();
        }
        this.queuesAccessedForRecovery.clear();
        this.openAllListableObjectStores();
    }

    private void openAllListableObjectStores() {
        if (this.getMuleContext() != null) {
            for (ListableObjectStore store : this.getMuleContext().getRegistry().lookupByType(ListableObjectStore.class).values()) {
                try {
                    store.open();
                }
                catch (ObjectStoreException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        }
    }

    @Override
    public void stop() throws MuleException {
        this.queueXaResourceManager.stop();
    }
}

