/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.queue.CacheAwareQueueStore;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.QueueStoreCacheListener;

public abstract class AbstractQueueManager
implements QueueManager,
QueueProvider,
QueueStoreCacheListener,
MuleContextAware,
Initialisable,
Disposable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final ReentrantLock queuesLock = new ReentrantLock();
    private final Map<String, CacheAwareQueueStore> queues = new HashMap<String, CacheAwareQueueStore>();
    private final Map<String, QueueConfiguration> queueConfigurations = new HashMap<String, QueueConfiguration>();
    private QueueConfiguration defaultQueueConfiguration = new DefaultQueueConfiguration();
    private MuleContext muleContext;

    @Override
    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = config;
    }

    @Override
    public synchronized void setQueueConfiguration(String queueName, QueueConfiguration newConfig) {
        if (this.queues.containsKey(queueName) && !newConfig.equals(this.queueConfigurations.get(queueName))) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage(String.format("A queue with name %s is in use so we cannot change it's configuration", queueName)));
        }
        if (this.logger.isDebugEnabled() && this.queueConfigurations.containsKey(queueName)) {
            QueueConfiguration oldConfiguration = this.queueConfigurations.get(queueName);
            this.logger.debug((Object)String.format("Replacing queue %s configuration: %s with new newConfig: %s", queueName, oldConfiguration, newConfig));
        }
        this.queueConfigurations.put(queueName, newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueStore getQueue(String name, QueueConfiguration config) {
        CacheAwareQueueStore queueStore = this.queues.get(name);
        if (queueStore != null) {
            return queueStore;
        }
        this.queuesLock.lock();
        try {
            queueStore = this.queues.get(name);
            if (queueStore == null) {
                queueStore = new CacheAwareQueueStore(this.createQueueStore(name, config), this);
                this.queues.put(name, queueStore);
            }
            CacheAwareQueueStore cacheAwareQueueStore = queueStore;
            return cacheAwareQueueStore;
        }
        finally {
            this.queuesLock.unlock();
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public final void dispose() {
        this.doDispose();
    }

    @Override
    public void disposeQueueStore(QueueStore queueStore) {
        this.removeQueueFromCache(queueStore);
    }

    @Override
    public void closeQueueStore(QueueStore queueStore) {
        this.removeQueueFromCache(queueStore);
    }

    private void removeQueueFromCache(QueueStore queueStore) {
        try {
            if (queueStore == null) {
                throw new IllegalArgumentException("Queue to be disposed cannot be null");
            }
            String queueName = queueStore.getName();
            this.queuesLock.lock();
            try {
                if (!this.queues.containsKey(queueName)) {
                    throw new IllegalArgumentException(String.format("There's no queue for name %s", queueName));
                }
                this.queues.remove(queueName);
            }
            finally {
                this.queuesLock.unlock();
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public synchronized QueueStore getQueue(String queueName) {
        return this.getQueue(queueName, this.defineQueueConfiguration(queueName));
    }

    private QueueConfiguration defineQueueConfiguration(String queueName) {
        if (!this.queueConfigurations.containsKey(queueName)) {
            this.setQueueConfiguration(queueName, this.defaultQueueConfiguration);
            return this.defaultQueueConfiguration;
        }
        return this.queueConfigurations.get(queueName);
    }

    protected void clearQueueConfiguration(String queueName) {
        this.queueConfigurations.remove(queueName);
    }

    protected abstract QueueStore createQueueStore(String var1, QueueConfiguration var2);

    protected abstract void doDispose();
}

