/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.processor.InternalMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.processor.chain.DynamicMessageProcessorContainer;
import org.mule.processor.chain.InterceptingChainLifecycleWrapperPathSkip;

public class NotificationUtils {
    private NotificationUtils() {
    }

    public static void addMessageProcessorPathElements(List<MessageProcessor> processors, MessageProcessorPathElement parentElement) {
        if (processors == null || parentElement == null) {
            return;
        }
        for (MessageProcessor mp : processors) {
            MessageProcessorPathElement messageProcessorPathElement;
            if (mp instanceof InternalMessageProcessor || (messageProcessorPathElement = mp instanceof InterceptingChainLifecycleWrapperPathSkip ? parentElement : parentElement.addChild(mp)) == null || !(mp instanceof MessageProcessorContainer)) continue;
            ((MessageProcessorContainer)((Object)mp)).addMessageProcessorPathElements(messageProcessorPathElement);
        }
    }

    public static FlowMap buildPathResolver(MessageProcessorPathElement element) {
        return new FlowMap(NotificationUtils.buildPaths(element, new LinkedHashMap<MessageProcessor, String>()));
    }

    @Deprecated
    public static Map<MessageProcessor, String> buildPaths(MessageProcessorPathElement element) {
        return NotificationUtils.buildPaths(element, new LinkedHashMap<MessageProcessor, String>());
    }

    private static Map<MessageProcessor, String> buildPaths(MessageProcessorPathElement element, Map<MessageProcessor, String> elements) {
        if (element.getMessageProcessor() != null) {
            elements.put(element.getMessageProcessor(), element.getPath());
        }
        List<MessageProcessorPathElement> children = element.getChildren();
        for (MessageProcessorPathElement child : children) {
            NotificationUtils.buildPaths(child, elements);
        }
        return elements;
    }

    public static class FlowMap
    implements PathResolver {
        private Map<MessageProcessor, String> flowMap = new ConcurrentHashMap<MessageProcessor, String>();
        private Map<DynamicMessageProcessorContainer, String> flowDynamicsMap = new ConcurrentHashMap<DynamicMessageProcessorContainer, String>();

        public FlowMap(Map<MessageProcessor, String> paths) {
            this.flowMap.putAll(paths);
            this.populateDynamicsMap(paths);
        }

        @Override
        public String resolvePath(MessageProcessor processor) {
            String path = this.flowMap.get(processor);
            if (path != null) {
                return path;
            }
            if (this.flowDynamicsMap.isEmpty()) {
                return null;
            }
            for (DynamicMessageProcessorContainer flowMapEntry : this.flowDynamicsMap.keySet()) {
                FlowMap resolvedInnerPaths = flowMapEntry.buildInnerPaths();
                if (resolvedInnerPaths == null) continue;
                Map<MessageProcessor, String> paths = resolvedInnerPaths.getFlowMap();
                this.flowMap.putAll(paths);
                this.populateDynamicsMap(paths);
            }
            return this.flowMap.get(processor);
        }

        private void populateDynamicsMap(Map<MessageProcessor, String> paths) {
            for (Map.Entry<MessageProcessor, String> flowMapEntry : paths.entrySet()) {
                if (!(flowMapEntry.getKey() instanceof DynamicMessageProcessorContainer)) continue;
                this.flowDynamicsMap.put((DynamicMessageProcessorContainer)flowMapEntry.getKey(), flowMapEntry.getValue());
            }
        }

        public Collection<String> getAllPaths() {
            return this.flowMap.values();
        }

        public Map<MessageProcessor, String> getFlowMap() {
            return this.flowMap;
        }
    }

    public static interface PathResolver {
        public String resolvePath(MessageProcessor var1);
    }
}

