/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class GetBeanProperty
extends AbstractTransformer {
    private String propertyName;
    private BeanUtilsBean beanUtilsBean;

    public GetBeanProperty() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
        this.beanUtilsBean = new BeanUtilsBean();
        this.beanUtilsBean.getPropertyUtils().addBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            return this.beanUtilsBean.getProperty(src, this.propertyName);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

