/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.graph.DirectedMultigraph;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.graph.TransformationEdge;

public class TransformationGraph
extends DirectedMultigraph<DataType<?>, TransformationEdge> {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Map<String, Converter> registeredConverters = new HashMap<String, Converter>();

    public TransformationGraph() {
        super(TransformationEdge.class);
    }

    public void addConverter(Converter converter) {
        if (this.registeredConverters.containsKey(TransformerUtils.getConverterKey(converter))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempting to register an already registered converter: " + converter));
            }
            return;
        }
        DataType<?> returnDataType = converter.getReturnDataType();
        if (!this.containsVertex(returnDataType)) {
            this.addVertex(returnDataType);
        }
        for (DataType<?> sourceDataType : converter.getSourceDataTypes()) {
            if (!this.containsVertex(sourceDataType)) {
                this.addVertex(sourceDataType);
            }
            this.addEdge(sourceDataType, returnDataType, new TransformationEdge(converter));
        }
        this.registeredConverters.put(TransformerUtils.getConverterKey(converter), converter);
    }

    public void removeConverter(Converter converter) {
        if (!this.registeredConverters.containsKey(TransformerUtils.getConverterKey(converter))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempt to remove an unregistered converter: " + converter));
            }
            return;
        }
        DataType<?> returnDataType = converter.getReturnDataType();
        for (DataType<?> sourceDataType : converter.getSourceDataTypes()) {
            Set allEdges = this.getAllEdges(sourceDataType, returnDataType);
            for (TransformationEdge edge : allEdges) {
                if (edge.getConverter() != converter) continue;
                DataType source = (DataType)this.getEdgeSource(edge);
                DataType target = (DataType)this.getEdgeTarget(edge);
                this.removeEdge(edge);
                if (this.inDegreeOf(source) == 0 && this.outDegreeOf(source) == 0) {
                    this.removeVertex(source);
                }
                if (this.inDegreeOf(target) != 0 || this.outDegreeOf(target) != 0) continue;
                this.removeVertex(target);
            }
        }
        this.registeredConverters.remove(TransformerUtils.getConverterKey(converter));
    }
}

