/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.graph.CompositeConverterFilter;
import org.mule.transformer.graph.NameConverterFilter;
import org.mule.transformer.graph.PriorityWeightingConverterFilter;
import org.mule.transformer.graph.SynchronizedTransformationGraph;
import org.mule.transformer.graph.TransformationGraphLookupStrategy;
import org.mule.transformer.graph.TransformationLengthConverterFilter;

public class GraphTransformerResolver
implements TransformerResolver {
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private SynchronizedTransformationGraph graph = new SynchronizedTransformationGraph();
    private CompositeConverterFilter converterFilter;
    private LRUMap cache;
    private TransformationGraphLookupStrategy lookupStrategyTransformation = new TransformationGraphLookupStrategy(this.graph);

    public GraphTransformerResolver() {
        this.converterFilter = new CompositeConverterFilter(new TransformationLengthConverterFilter(), new PriorityWeightingConverterFilter(), new NameConverterFilter());
        this.cache = new LRUMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformer resolve(DataType<?> source, DataType<?> result) throws ResolverException {
        String cacheKey = this.getDataTypeSourceResultPairHash(source, result);
        this.readWriteLock.readLock().lock();
        try {
            if (this.cache.containsKey((Object)cacheKey)) {
                Converter converter = (Converter)this.cache.get((Object)cacheKey);
                return converter;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        List<Converter> converters = this.converterFilter.filter(this.lookupStrategyTransformation.lookupConverters(source, result), source, result);
        if (converters.size() > 1) {
            throw new ResolverException(CoreMessages.transformHasMultipleMatches(source.getType(), result.getType(), converters));
        }
        Converter converter = converters.size() == 0 ? null : converters.get(0);
        this.readWriteLock.writeLock().lock();
        try {
            this.cache.put((Object)cacheKey, (Object)converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return converter;
    }

    private String getDataTypeSourceResultPairHash(DataType<?> source, DataType<?> result) {
        StringBuilder builder = new StringBuilder();
        builder.append(source.getClass().getName());
        builder.append(source.hashCode());
        builder.append(":");
        builder.append(result.getClass().getName());
        builder.append(result.hashCode());
        return builder.toString();
    }

    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        this.readWriteLock.writeLock().lock();
        try {
            if (!(transformer instanceof Converter)) {
                return;
            }
            this.cache.clear();
            if (registryAction == TransformerResolver.RegistryAction.ADDED) {
                this.graph.addConverter((Converter)transformer);
            } else if (registryAction == TransformerResolver.RegistryAction.REMOVED) {
                this.graph.removeConverter((Converter)transformer);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

