/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import javax.inject.Inject;
import org.mule.api.MuleMessage;
import org.mule.api.serialization.DefaultObjectSerializer;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.api.transport.SessionHandler;
import org.mule.serialization.internal.MuleSessionWithNativeTypesSerializer;
import org.mule.util.store.DeserializationPostInitialisable;

public abstract class AbstractSessionHandler
implements SessionHandler {
    public static final String ACTIVATE_NATIVE_SESSION_SERIALIZATION_PROPERTY = "mule.session.serialization.native.enable";
    protected boolean ACTIVATE_NATIVE_SESSION_SERIALIZATION = Boolean.getBoolean("mule.session.serialization.native.enable");
    private ObjectSerializer nativeObjectSerializer = new MuleSessionWithNativeTypesSerializer();
    private ObjectSerializerLocator objectSerializerLocator = new FromMessageObjectSerializerLocator();
    private ObjectSerializer wrappedSerializer = null;

    protected <T> T deserialize(MuleMessage message, byte[] bytes) {
        return this.deserialize(message, bytes, this.nativeObjectSerializer);
    }

    private boolean isNativeSerializationActivated(String endpoint) {
        return this.ACTIVATE_NATIVE_SESSION_SERIALIZATION;
    }

    private <T> T deserialize(MuleMessage message, byte[] bytes, ObjectSerializer objectSerializer) {
        Object object = this.isNativeSerializationActivated(this.getEndpoint(message)) ? this.nativeObjectSerializer.deserialize(bytes, message.getMuleContext().getExecutionClassLoader()) : this.objectSerializerLocator.getObjectSerializer(message).deserialize(bytes, message.getMuleContext().getExecutionClassLoader());
        if (object instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(object, message.getMuleContext());
            }
            catch (Exception e) {
                throw new SerializationException("Could not initialise session after deserialization", (Throwable)e);
            }
        }
        return object;
    }

    protected byte[] serialize(MuleMessage message, Object object) {
        if (this.isNativeSerializationActivated(this.getEndpoint(message))) {
            return this.nativeObjectSerializer.serialize(object);
        }
        return this.objectSerializerLocator.getObjectSerializer(message).serialize(object);
    }

    protected String getEndpoint(MuleMessage message) {
        return String.valueOf(message.getInboundProperty("MULE_ENDPOINT"));
    }

    @Inject
    @DefaultObjectSerializer
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializerLocator = new FixedObjectSerializerLocator(objectSerializer);
    }

    private class FromMessageObjectSerializerLocator
    implements ObjectSerializerLocator {
        private FromMessageObjectSerializerLocator() {
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return message.getMuleContext().getObjectSerializer();
        }
    }

    private class FixedObjectSerializerLocator
    implements ObjectSerializerLocator {
        private final ObjectSerializer objectSerializer;

        private FixedObjectSerializerLocator(ObjectSerializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return this.objectSerializer;
        }
    }

    private static interface ObjectSerializerLocator {
        public ObjectSerializer getObjectSerializer(MuleMessage var1);
    }
}

