/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.WriteAbortedException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

public class NodeWrapper
implements Serializable,
Node {
    public static final String NODE_WRAPPER_ENVELOPE_OPEN_TAG = "<node-wrapper-envelope>";
    public static final String NODE_WRAPPER_ENVELOPE_CLOSE_TAG = "</node-wrapper-envelope>";
    public static final String CDATA_OPEN = "<![CDATA[";
    public static final String CDATA_CLOSE = "]]>";
    private final short nodeType;
    private final String nodeName;
    private transient Node node;
    private String nodeAsString;

    public NodeWrapper(Node node) {
        this.node = node;
        this.nodeType = node.getNodeType();
        this.nodeName = node.getNodeName();
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            if (4 == this.node.getNodeType()) {
                this.nodeAsString = "<node-wrapper-envelope><![CDATA[" + this.node.getNodeValue() + CDATA_CLOSE + NODE_WRAPPER_ENVELOPE_CLOSE_TAG;
                return this;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(this.getSerializingNode(this.node)), new StreamResult(writer));
            this.nodeAsString = NODE_WRAPPER_ENVELOPE_OPEN_TAG + writer.toString() + NODE_WRAPPER_ENVELOPE_CLOSE_TAG;
            return this;
        }
        catch (TransformerException e) {
            throw new WriteAbortedException("Error while serializing Dom object", e);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document parse = dBuilder.parse(new ByteArrayInputStream(this.nodeAsString.getBytes()));
            this.node = this.getDeserializingNode(parse.getFirstChild());
        }
        catch (SAXException e) {
            throw new WriteAbortedException("Error while deserializing Dom object", e);
        }
        catch (IOException e) {
            throw new WriteAbortedException("Error while deserializing Dom object", e);
        }
        catch (ParserConfigurationException e) {
            throw new WriteAbortedException("Error while deserializing Dom object", e);
        }
        return this;
    }

    private Node getSerializingNode(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return ((Attr)this.node).getOwnerElement();
            }
        }
        return this.node;
    }

    private Node getDeserializingNode(Node node) {
        switch (this.nodeType) {
            case 2: {
                return node.getFirstChild().getAttributes().getNamedItem(this.nodeName);
            }
        }
        return node.getFirstChild();
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public String getNodeName() {
        return this.node.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.node.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return this.node.getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.node.getParentNode();
    }

    @Override
    public NodeList getChildNodes() {
        return this.node.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return this.node.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.node.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.node.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.node.getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.node.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.node.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return this.node.removeChild(oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.node.appendChild(newChild);
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.node.cloneNode(deep);
    }

    @Override
    public void normalize() {
        this.node.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.node.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.node.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.node.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.node.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.node.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.node.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.node.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.node.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.node.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.node.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.node.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.node.getUserData(key);
    }

    public String toString() {
        return this.node.toString();
    }
}

