/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.serialization.internal.AbstractObjectSerializer;
import org.mule.util.Preconditions;
import org.mule.util.SerializationUtils;

public class JavaObjectSerializer
extends AbstractObjectSerializer {
    public JavaObjectSerializer() {
    }

    JavaObjectSerializer(ObjectSerializer other) {
        super(other);
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        this.validateForSerialization(object);
        SerializationUtils.serialize((Serializable)((Serializable)object), (OutputStream)out);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        this.validateForSerialization(object);
        return SerializationUtils.serialize((Serializable)((Serializable)object));
    }

    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        Preconditions.checkArgument(classLoader != null, "Cannot deserialize with a null classloader");
        return (T)SerializationUtils.deserialize(inputStream, classLoader, this.muleContext);
    }

    @Override
    protected <T> T postInitialize(T object) {
        return object;
    }

    private void validateForSerialization(Object object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new SerializationException(String.format("Was expecting a Serializable type. %s was found instead", object.getClass().getName()));
        }
    }
}

