/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.AbstractSplitter;
import org.mule.routing.MapSplitter;
import org.mule.serialization.internal.NodeWrapper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpressionSplitter
extends AbstractSplitter
implements Initialisable {
    protected ExpressionManager expressionManager;
    protected ExpressionConfig config = new ExpressionConfig();

    public ExpressionSplitter() {
    }

    public ExpressionSplitter(ExpressionConfig config) {
        this.config = config;
        this.setEvaluator(config.getEvaluator());
    }

    @Override
    public void initialise() throws InitialisationException {
        this.expressionManager = this.muleContext.getExpressionManager();
        this.config.validate(this.expressionManager);
    }

    @Override
    protected List<MuleMessage> splitMessage(MuleEvent event) {
        List<Object> result = event.getMuleContext().getExpressionManager().evaluate(this.config.getFullExpression(this.expressionManager), event);
        if (result instanceof Object[]) {
            result = Arrays.asList((Object[])result);
        }
        if (result instanceof Collection) {
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
            for (Object object : (Collection)result) {
                messages.add(new DefaultMuleMessage(object, this.muleContext));
            }
            return messages;
        }
        if (result instanceof Map) {
            LinkedList<MuleMessage> list = new LinkedList<MuleMessage>();
            Set set = ((Map)((Object)result)).entrySet();
            for (Map.Entry entry : set) {
                DefaultMuleMessage message = new DefaultMuleMessage(entry.getValue(), this.muleContext);
                message.setInvocationProperty(MapSplitter.MAP_ENTRY_KEY, entry.getKey());
                list.add(message);
            }
            return list;
        }
        if (result instanceof MuleMessage) {
            return Collections.singletonList((MuleMessage)((Object)result));
        }
        if (result instanceof NodeList) {
            NodeList nodeList = (NodeList)((Object)result);
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node item = nodeList.item(i);
                messages.add(new DefaultMuleMessage(new NodeWrapper(item), this.muleContext));
            }
            return messages;
        }
        if (result instanceof Iterator) {
            Iterator iterator = (Iterator)((Object)result);
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
            while (iterator.hasNext()) {
                messages.add(new DefaultMuleMessage(iterator.next(), this.muleContext));
            }
            return messages;
        }
        if (result == null) {
            return new ArrayList<MuleMessage>();
        }
        this.logger.info((Object)("The expression does not evaluate to a type that can be split: " + result.getClass().getName()));
        return Collections.singletonList(new DefaultMuleMessage(result, this.muleContext));
    }

    public String getCustomEvaluator() {
        return this.config.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.config.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.config.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        if (evaluator != null && evaluator.equals("xpath")) {
            evaluator = "xpath-node";
        }
        this.config.setEvaluator(evaluator);
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }

    @Override
    protected boolean isSequential() {
        return true;
    }
}

