/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.strategy;

import java.io.Serializable;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.processor.StageNameSource;
import org.mule.api.store.QueueStore;
import org.mule.config.QueueProfile;
import org.mule.management.stats.QueueStatistics;
import org.mule.management.stats.QueueStatisticsAware;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.SedaStageInterceptingMessageProcessor;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.util.concurrent.ThreadNameHelper;

public class QueuedAsynchronousProcessingStrategy
extends AsynchronousProcessingStrategy
implements QueueStatisticsAware {
    protected Integer queueTimeout;
    protected Integer maxQueueSize = 0;
    protected QueueStore<Serializable> queueStore = null;
    protected QueueStatistics queueStatistics;

    @Override
    protected AsyncInterceptingMessageProcessor createAsyncMessageProcessor(StageNameSource nameSource, MuleContext muleContext) {
        Integer timeout = this.queueTimeout != null ? this.queueTimeout.intValue() : muleContext.getConfiguration().getDefaultQueueTimeout();
        this.initQueueStore(muleContext);
        QueueProfile queueProfile = new QueueProfile(this.maxQueueSize, this.queueStore);
        ThreadingProfile threadingProfile = this.createThreadingProfile(muleContext);
        String stageName = nameSource.getName();
        return new SedaStageInterceptingMessageProcessor(ThreadNameHelper.flow(muleContext, stageName), stageName, queueProfile, timeout, threadingProfile, this.queueStatistics, muleContext);
    }

    protected void initQueueStore(MuleContext muleContext) {
        if (this.queueStore == null) {
            this.queueStore = (QueueStore)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore");
        }
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public QueueStore<Serializable> getQueueStore() {
        return this.queueStore;
    }

    public void setQueueStore(QueueStore<Serializable> queueStore) {
        this.queueStore = queueStore;
    }

    public QueueStatistics getQueueStatistics() {
        return this.queueStatistics;
    }

    @Override
    public void setQueueStatistics(QueueStatistics queueStatistics) {
        this.queueStatistics = queueStatistics;
    }
}

