/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.NotificationUtils;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Lifecycle,
MuleContextAware,
FlowConstructAware {
    protected MessagingExceptionHandler exceptionListener;
    protected MuleTransactionConfig transactionConfig;

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        boolean noPreviousTransactionToJoinOrSuspend = TransactionCoordination.getInstance().getTransaction() == null;
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate(this.muleContext, this.transactionConfig, this.exceptionListener);
        ExecutionCallback<MuleEvent> processingCallback = new ExecutionCallback<MuleEvent>(){

            @Override
            public MuleEvent process() throws Exception {
                return TransactionalInterceptingMessageProcessor.this.processNext(event);
            }
        };
        try {
            MuleEvent result = executionTemplate.execute(processingCallback);
            if (result == null || VoidMuleEvent.getInstance() == result) {
                return result;
            }
            return this.resetTransactedFlag(result, noPreviousTransactionToJoinOrSuspend);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), (Throwable)e);
        }
    }

    protected MuleEvent resetTransactedFlag(MuleEvent result, boolean mustForceTransactionResolution) throws TransactionException {
        if (mustForceTransactionResolution && TransactionCoordination.getInstance().getTransaction() != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
        return new DefaultMuleEvent(result, TransactionCoordination.getInstance().getTransaction() != null);
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.exceptionListener == null) {
            this.exceptionListener = this.muleContext.getDefaultExceptionStrategy();
        }
        if (this.exceptionListener instanceof Initialisable) {
            ((Initialisable)((Object)this.exceptionListener)).initialise();
        }
    }

    @Override
    public void dispose() {
        if (this.exceptionListener instanceof Disposable) {
            ((Disposable)((Object)this.exceptionListener)).dispose();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.exceptionListener instanceof Startable) {
            ((Startable)((Object)this.exceptionListener)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.exceptionListener instanceof Stoppable) {
            ((Stoppable)((Object)this.exceptionListener)).stop();
        }
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.next instanceof MessageProcessorChain) {
            NotificationUtils.addMessageProcessorPathElements(((MessageProcessorChain)this.next).getMessageProcessors(), pathElement);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        if (this.exceptionListener != null && this.exceptionListener instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.exceptionListener)).setFlowConstruct(flowConstruct);
        }
    }
}

