/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.HasLifecycleInterceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleInterceptor;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.RegistryLifecycleHelpers;
import org.mule.api.lifecycle.Startable;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.AbstractLifecycleManager;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.lifecycle.PhaseErrorLifecycleInterceptor;
import org.mule.lifecycle.RegistryLifecycleCallback;
import org.mule.lifecycle.phases.MuleContextDisposePhase;
import org.mule.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.lifecycle.phases.MuleContextStartPhase;
import org.mule.lifecycle.phases.MuleContextStopPhase;
import org.mule.transport.ConnectException;

public class RegistryLifecycleManager
extends AbstractLifecycleManager<Registry>
implements RegistryLifecycleHelpers {
    protected Map<String, LifecyclePhase> phases = new HashMap<String, LifecyclePhase>();
    protected SortedMap<String, LifecycleCallback> callbacks = new TreeMap<String, LifecycleCallback>();
    protected MuleContext muleContext;
    private final LifecycleInterceptor initDisposeLifecycleInterceptor = new PhaseErrorLifecycleInterceptor("initialise", "dispose", Initialisable.class);
    private final LifecycleInterceptor startstopLifecycleInterceptor = new PhaseErrorLifecycleInterceptor("start", "stop", Startable.class);

    public RegistryLifecycleManager(String id, Registry object, MuleContext muleContext) {
        super(id, object);
        this.muleContext = muleContext;
        this.registerPhases();
    }

    protected void registerPhases() {
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback(this);
        EmptyLifecycleCallback emptyCallback = new EmptyLifecycleCallback();
        this.registerPhase("not in lifecycle", NOT_IN_LIFECYCLE_PHASE, emptyCallback);
        this.registerPhase("initialise", new MuleContextInitialisePhase(), callback);
        this.registerPhase("start", new MuleContextStartPhase(), emptyCallback);
        this.registerPhase("stop", new MuleContextStopPhase(), emptyCallback);
        this.registerPhase("dispose", new MuleContextDisposePhase(), callback);
    }

    public RegistryLifecycleManager(String id, Registry object, Map<String, LifecyclePhase> phases) {
        super(id, object);
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback(this);
        this.registerPhase("not in lifecycle", NOT_IN_LIFECYCLE_PHASE, new LifecycleCallback(){

            public void onTransition(String phaseName, Object object) throws MuleException {
            }
        });
        for (Map.Entry<String, LifecyclePhase> entry : phases.entrySet()) {
            this.registerPhase(entry.getKey(), entry.getValue(), callback);
        }
    }

    @Override
    protected void registerTransitions() {
        this.addDirectTransition("not in lifecycle", "initialise");
        this.addDirectTransition("initialise", "start");
        this.addDirectTransition("start", "stop");
        this.addDirectTransition("stop", "start");
        this.addDirectTransition("not in lifecycle", "dispose");
        this.addDirectTransition("initialise", "dispose");
        this.addDirectTransition("stop", "dispose");
    }

    protected void registerPhase(String phaseName, LifecyclePhase phase) {
        this.registerPhase(phaseName, phase, new RegistryLifecycleCallback(this));
    }

    protected void registerPhase(String phaseName, LifecyclePhase phase, LifecycleCallback callback) {
        if (callback instanceof HasLifecycleInterceptor) {
            if ("initialise".equals(phaseName) || "dispose".equals(phaseName)) {
                ((HasLifecycleInterceptor)((Object)callback)).setLifecycleInterceptor(this.initDisposeLifecycleInterceptor);
            }
            if ("start".equals(phaseName) || "stop".equals(phaseName)) {
                ((HasLifecycleInterceptor)((Object)callback)).setLifecycleInterceptor(this.startstopLifecycleInterceptor);
            }
        }
        this.phaseNames.add(phaseName);
        this.callbacks.put(phaseName, callback);
        this.phases.put(phaseName, phase);
    }

    @Override
    public void fireLifecycle(String destinationPhase) throws LifecycleException {
        this.checkPhase(destinationPhase);
        if (this.isDirectTransition(destinationPhase) || this.isLastPhaseExecutionFailed()) {
            this.invokePhase(destinationPhase, this.object, (LifecycleCallback)this.callbacks.get(destinationPhase));
        } else {
            boolean start = false;
            for (String phase : this.phaseNames) {
                if (start) {
                    this.invokePhase(phase, this.object, (LifecycleCallback)this.callbacks.get(phase));
                    if (phase.equals(destinationPhase)) break;
                }
                if (!phase.equals(this.getCurrentPhase())) continue;
                start = true;
            }
        }
    }

    protected void doOnConnectException(ConnectException ce) throws LifecycleException {
        throw new LifecycleException(ce, (Object)this);
    }

    @Override
    public void applyPhase(Object object, String fromPhase, String toPhase) throws LifecycleException {
        if (fromPhase == null || toPhase == null) {
            throw new IllegalArgumentException("toPhase and fromPhase must be null");
        }
        if (!this.phaseNames.contains(fromPhase)) {
            throw new IllegalArgumentException("fromPhase '" + fromPhase + "' not a valid phase.");
        }
        if (!this.phaseNames.contains(toPhase)) {
            throw new IllegalArgumentException("toPhase '" + fromPhase + "' not a valid phase.");
        }
        boolean start = false;
        for (String phaseName : this.phaseNames) {
            if (start) {
                this.phases.get(phaseName).applyLifecycle(object);
            }
            if (toPhase.equals(phaseName)) break;
            if (!phaseName.equals(fromPhase)) continue;
            start = true;
        }
    }

    @Override
    public void applyCompletedPhases(Object object) throws LifecycleException {
        String lastPhase = "not in lifecycle";
        for (String phase : this.completedPhases) {
            if (!this.isDirectTransition(lastPhase, phase)) continue;
            LifecyclePhase lp = this.phases.get(phase);
            lp.applyLifecycle(object);
            lastPhase = phase;
        }
    }
}

