/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.transformer.DataType;
import org.mule.expression.MessagePayloadExpressionEvaluator;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;
import org.mule.util.StringUtils;

public class MessageExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "message";
    public static final String PAYLOAD = "payload";
    protected final transient Log logger = LogFactory.getLog(MessagePayloadExpressionEvaluator.class);

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        if (StringUtils.isEmpty((String)expression) || message == null) {
            return message;
        }
        if (expression.equals("id")) {
            return message.getUniqueId();
        }
        if (expression.equals("correlationId")) {
            return message.getCorrelationId();
        }
        if (expression.equals("correlationSequence")) {
            return message.getCorrelationSequence();
        }
        if (expression.equals("correlationGroupSize")) {
            return message.getCorrelationGroupSize();
        }
        if (expression.equals("replyTo")) {
            return message.getReplyTo();
        }
        if (expression.equals(PAYLOAD)) {
            return message.getPayload();
        }
        if (expression.equals("encoding")) {
            return message.getEncoding();
        }
        if (expression.equals("exception")) {
            ExceptionPayload ep = message.getExceptionPayload();
            if (ep != null) {
                return ep.getException();
            }
            return null;
        }
        throw new IllegalArgumentException(expression);
    }

    @Override
    public TypedValue evaluateTyped(String expression, MuleMessage message) {
        Object value = this.evaluate(expression, message);
        Class type = value == null ? Object.class : value.getClass();
        DataType<Object> dataType = expression.equals(PAYLOAD) ? message.getDataType() : DataTypeFactory.create(type, null);
        return new TypedValue(value, dataType);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

